/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.signature.CAdESLevelBaselineB;
import eu.europa.esig.dss.signature.BaselineBCertificateSelector;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.x509.CertificateToken;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import org.bouncycastle.cms.SimpleAttributeTableGenerator;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.Store;

public class CMSSignedDataBuilder {
    private final CertificateVerifier certificateVerifier;

    public CMSSignedDataBuilder(CertificateVerifier certificateVerifier) {
        this.certificateVerifier = certificateVerifier;
    }

    protected CMSSignedDataGenerator createCMSSignedDataGenerator(CAdESSignatureParameters parameters, ContentSigner contentSigner, SignerInfoGeneratorBuilder signerInfoGeneratorBuilder, CMSSignedData originalSignedData) throws DSSException {
        try {
            CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
            SignerInfoGenerator signerInfoGenerator = this.getSignerInfoGenerator(signerInfoGeneratorBuilder, contentSigner, parameters);
            generator.addSignerInfoGenerator(signerInfoGenerator);
            LinkedList<CertificateToken> certificateChain = new LinkedList<CertificateToken>();
            if (originalSignedData != null) {
                generator.addSigners(originalSignedData.getSignerInfos());
                generator.addAttributeCertificates(originalSignedData.getAttributeCertificates());
                generator.addCRLs(originalSignedData.getCRLs());
                generator.addOtherRevocationInfo(OCSPObjectIdentifiers.id_pkix_ocsp_basic, originalSignedData.getOtherRevocationInfo(OCSPObjectIdentifiers.id_pkix_ocsp_basic));
                generator.addOtherRevocationInfo(CMSObjectIdentifiers.id_ri_ocsp_response, originalSignedData.getOtherRevocationInfo(CMSObjectIdentifiers.id_ri_ocsp_response));
                Store certificates = originalSignedData.getCertificates();
                Collection certificatesMatches = certificates.getMatches(null);
                for (X509CertificateHolder certificatesMatch : certificatesMatches) {
                    CertificateToken token = DSSASN1Utils.getCertificate((X509CertificateHolder)certificatesMatch);
                    if (certificateChain.contains(token)) continue;
                    certificateChain.add(token);
                }
            }
            JcaCertStore jcaCertStore = this.getJcaCertStore(certificateChain, parameters);
            generator.addCertificates((Store)jcaCertStore);
            return generator;
        }
        catch (CMSException | OperatorCreationException e) {
            throw new DSSException(e);
        }
    }

    SignerInfoGeneratorBuilder getSignerInfoGeneratorBuilder(DigestCalculatorProvider digestCalculatorProvider, CAdESSignatureParameters parameters, boolean includeUnsignedAttributes) {
        CAdESLevelBaselineB cadesProfile = new CAdESLevelBaselineB();
        AttributeTable signedAttributes = cadesProfile.getSignedAttributes(parameters);
        AttributeTable unsignedAttributes = null;
        if (includeUnsignedAttributes) {
            unsignedAttributes = cadesProfile.getUnsignedAttributes();
        }
        return this.getSignerInfoGeneratorBuilder(digestCalculatorProvider, signedAttributes, unsignedAttributes);
    }

    private SignerInfoGeneratorBuilder getSignerInfoGeneratorBuilder(DigestCalculatorProvider digestCalculatorProvider, AttributeTable signedAttributes, AttributeTable unsignedAttributes) {
        if (DSSASN1Utils.isEmpty((AttributeTable)signedAttributes)) {
            signedAttributes = null;
        }
        DefaultSignedAttributeTableGenerator signedAttributeGenerator = new DefaultSignedAttributeTableGenerator(signedAttributes);
        if (DSSASN1Utils.isEmpty((AttributeTable)unsignedAttributes)) {
            unsignedAttributes = null;
        }
        SimpleAttributeTableGenerator unsignedAttributeGenerator = new SimpleAttributeTableGenerator(unsignedAttributes);
        SignerInfoGeneratorBuilder sigInfoGeneratorBuilder = new SignerInfoGeneratorBuilder(digestCalculatorProvider);
        sigInfoGeneratorBuilder.setSignedAttributeGenerator((CMSAttributeTableGenerator)signedAttributeGenerator);
        sigInfoGeneratorBuilder.setUnsignedAttributeGenerator((CMSAttributeTableGenerator)unsignedAttributeGenerator);
        return sigInfoGeneratorBuilder;
    }

    private SignerInfoGenerator getSignerInfoGenerator(SignerInfoGeneratorBuilder signerInfoGeneratorBuilder, ContentSigner contentSigner, CAdESSignatureParameters parameters) throws OperatorCreationException {
        CertificateToken signingCertificate = parameters.getSigningCertificate();
        if (signingCertificate == null && parameters.isGenerateTBSWithoutCertificate()) {
            SignerId signerId = new SignerId(DSSUtils.EMPTY_BYTE_ARRAY);
            return signerInfoGeneratorBuilder.build(contentSigner, signerId.getSubjectKeyIdentifier());
        }
        X509CertificateHolder certHolder = DSSASN1Utils.getX509CertificateHolder((CertificateToken)signingCertificate);
        return signerInfoGeneratorBuilder.build(contentSigner, certHolder);
    }

    private JcaCertStore getJcaCertStore(Collection<CertificateToken> certificateChain, CAdESSignatureParameters parameters) {
        BaselineBCertificateSelector certificateSelectors = new BaselineBCertificateSelector(this.certificateVerifier, (AbstractSignatureParameters)parameters);
        ArrayList certificatesToAdd = parameters.getSigningCertificate() == null && parameters.isGenerateTBSWithoutCertificate() ? new ArrayList() : certificateSelectors.getCertificates();
        for (CertificateToken certificateToken : certificatesToAdd) {
            if (certificateChain.contains(certificateToken)) continue;
            certificateChain.add(certificateToken);
        }
        try {
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
            for (CertificateToken certificateInChain : certificateChain) {
                certs.add(certificateInChain.getCertificate());
            }
            return new JcaCertStore(certs);
        }
        catch (CertificateEncodingException e) {
            throw new DSSException((Throwable)e);
        }
    }

    protected CMSSignedData regenerateCMSSignedData(CMSSignedData cmsSignedData, CAdESSignatureParameters parameters, Store certificatesStore, Store attributeCertificatesStore, Store crlsStore, Store otherRevocationInfoFormatStoreBasic, Store otherRevocationInfoFormatStoreOcsp) {
        try {
            boolean encapsulate;
            CMSSignedDataGenerator cmsSignedDataGenerator = new CMSSignedDataGenerator();
            cmsSignedDataGenerator.addSigners(cmsSignedData.getSignerInfos());
            cmsSignedDataGenerator.addAttributeCertificates(attributeCertificatesStore);
            cmsSignedDataGenerator.addCertificates(certificatesStore);
            cmsSignedDataGenerator.addCRLs(crlsStore);
            cmsSignedDataGenerator.addOtherRevocationInfo(OCSPObjectIdentifiers.id_pkix_ocsp_basic, otherRevocationInfoFormatStoreBasic);
            cmsSignedDataGenerator.addOtherRevocationInfo(CMSObjectIdentifiers.id_ri_ocsp_response, otherRevocationInfoFormatStoreOcsp);
            boolean bl = encapsulate = cmsSignedData.getSignedContent() != null;
            if (!encapsulate) {
                List detachedContents = parameters.getDetachedContents();
                DSSDocument doc = (DSSDocument)detachedContents.get(0);
                CMSProcessableByteArray content = new CMSProcessableByteArray(DSSUtils.toByteArray((DSSDocument)doc));
                cmsSignedData = cmsSignedDataGenerator.generate((CMSTypedData)content, encapsulate);
            } else {
                cmsSignedData = cmsSignedDataGenerator.generate(cmsSignedData.getSignedContent(), encapsulate);
            }
            return cmsSignedData;
        }
        catch (CMSException e) {
            throw new DSSException((Throwable)e);
        }
    }
}

