/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation.timestamp;

import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.validation.CAdESAttribute;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CAdESSignedAttributes;
import eu.europa.esig.dss.cades.validation.CAdESUnsignedAttributes;
import eu.europa.esig.dss.cades.validation.timestamp.CAdESTimestampDataBuilder;
import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OfflineOCSPSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CMSCRLSource;
import eu.europa.esig.dss.validation.CMSCertificateSource;
import eu.europa.esig.dss.validation.CMSOCSPSource;
import eu.europa.esig.dss.validation.SignatureCertificateSource;
import eu.europa.esig.dss.validation.SignatureProperties;
import eu.europa.esig.dss.validation.timestamp.SignatureTimestampSource;
import eu.europa.esig.dss.validation.timestamp.TimestampSource;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.OtherRevocationInfoFormat;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.esf.CrlListID;
import org.bouncycastle.asn1.esf.CrlOcspRef;
import org.bouncycastle.asn1.esf.CrlValidatedID;
import org.bouncycastle.asn1.esf.OcspListID;
import org.bouncycastle.asn1.esf.OcspResponsesID;
import org.bouncycastle.asn1.esf.RevocationValues;
import org.bouncycastle.asn1.ess.OtherCertID;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESTimestampSource
extends SignatureTimestampSource<CAdESSignature, CAdESAttribute> {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESTimestampSource.class);

    public CAdESTimestampSource(CAdESSignature signature) {
        super((AdvancedSignature)signature);
    }

    protected CAdESTimestampDataBuilder getTimestampDataBuilder() {
        return new CAdESTimestampDataBuilder((CAdESSignature)this.signature, this.certificateSource);
    }

    protected SignatureProperties<CAdESAttribute> buildSignedSignatureProperties() {
        return CAdESSignedAttributes.build(((CAdESSignature)this.signature).getSignerInformation());
    }

    protected SignatureProperties<CAdESAttribute> buildUnsignedSignatureProperties() {
        return CAdESUnsignedAttributes.build(((CAdESSignature)this.signature).getSignerInformation());
    }

    protected boolean isContentTimestamp(CAdESAttribute signedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_contentTimestamp.equals((ASN1Primitive)signedAttribute.getASN1Oid());
    }

    protected boolean isAllDataObjectsTimestamp(CAdESAttribute signedAttribute) {
        return false;
    }

    protected boolean isIndividualDataObjectsTimestamp(CAdESAttribute signedAttribute) {
        return false;
    }

    protected boolean isSignatureTimestamp(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_signatureTimeStampToken.equals((ASN1Primitive)unsignedAttribute.getASN1Oid());
    }

    protected boolean isCompleteCertificateRef(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_certificateRefs.equals((ASN1Primitive)unsignedAttribute.getASN1Oid());
    }

    protected boolean isAttributeCertificateRef(CAdESAttribute unsignedAttribute) {
        return OID.attributeCertificateRefsOid.equals((ASN1Primitive)unsignedAttribute.getASN1Oid());
    }

    protected boolean isCompleteRevocationRef(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_revocationRefs.equals((ASN1Primitive)unsignedAttribute.getASN1Oid());
    }

    protected boolean isAttributeRevocationRef(CAdESAttribute unsignedAttribute) {
        return OID.attributeRevocationRefsOid.equals((ASN1Primitive)unsignedAttribute.getASN1Oid());
    }

    protected boolean isRefsOnlyTimestamp(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_certCRLTimestamp.equals((ASN1Primitive)unsignedAttribute.getASN1Oid());
    }

    protected boolean isSigAndRefsTimestamp(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_escTimeStamp.equals((ASN1Primitive)unsignedAttribute.getASN1Oid());
    }

    protected boolean isCertificateValues(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_certValues.equals((ASN1Primitive)unsignedAttribute.getASN1Oid());
    }

    protected boolean isRevocationValues(CAdESAttribute unsignedAttribute) {
        return PKCSObjectIdentifiers.id_aa_ets_revocationValues.equals((ASN1Primitive)unsignedAttribute.getASN1Oid());
    }

    protected boolean isAttrAuthoritiesCertValues(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isAttributeRevocationValues(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isArchiveTimestamp(CAdESAttribute unsignedAttribute) {
        return this.isArchiveTimestampV2(unsignedAttribute) || this.isArchiveTimestampV3(unsignedAttribute);
    }

    private boolean isArchiveTimestampV2(CAdESAttribute unsignedAttribute) {
        return OID.id_aa_ets_archiveTimestampV2.equals((ASN1Primitive)unsignedAttribute.getASN1Oid());
    }

    private boolean isArchiveTimestampV3(CAdESAttribute unsignedAttribute) {
        return OID.id_aa_ets_archiveTimestampV3.equals((ASN1Primitive)unsignedAttribute.getASN1Oid());
    }

    protected boolean isTimeStampValidationData(CAdESAttribute unsignedAttribute) {
        return false;
    }

    protected boolean isCounterSignature(CAdESAttribute unsignedAttribute) {
        return CMSAttributes.counterSignature.equals((ASN1Primitive)unsignedAttribute.getASN1Oid());
    }

    protected boolean isSignaturePolicyStore(CAdESAttribute unsignedAttribute) {
        return OID.id_aa_ets_sigPolicyStore.equals((ASN1Primitive)unsignedAttribute.getASN1Oid());
    }

    protected TimestampToken makeTimestampToken(CAdESAttribute signatureAttribute, TimestampType timestampType, List<TimestampedReference> references) {
        TimeStampToken timestamp = signatureAttribute.toTimeStampToken();
        if (timestamp == null) {
            return null;
        }
        return new TimestampToken(timestamp, timestampType, references);
    }

    protected void incorporateArchiveTimestampReferences(TimestampToken timestampToken, List<TimestampToken> previousTimestamps) {
        if (this.isArchiveTimestampV2(timestampToken)) {
            super.incorporateArchiveTimestampReferences(timestampToken, previousTimestamps);
        }
        ArrayList timestampedReferences = new ArrayList();
        this.addReferences(timestampedReferences, this.getSignatureTimestampReferences());
        ASN1Sequence atsHashIndex = DSSASN1Utils.getAtsHashIndex((AttributeTable)timestampToken.getUnsignedAttributes());
        if (atsHashIndex != null) {
            DigestAlgorithm digestAlgorithm = this.getHashIndexDigestAlgorithm(atsHashIndex);
            ASN1Sequence certsHashIndex = DSSASN1Utils.getCertificatesHashIndex((ASN1Sequence)atsHashIndex);
            ASN1Sequence crlHashIndex = DSSASN1Utils.getCRLHashIndex((ASN1Sequence)atsHashIndex);
            this.addReferences(timestampedReferences, this.getSignedDataCertificateReferences(certsHashIndex, digestAlgorithm));
            this.addReferences(timestampedReferences, this.getSignedDataRevocationReferences(crlHashIndex, digestAlgorithm));
            ASN1Sequence unsignedAttrsHashIndex = DSSASN1Utils.getUnsignedAttributesHashIndex((ASN1Sequence)atsHashIndex);
            this.addReferences(timestampedReferences, this.getUnsignedAttributesReferences(unsignedAttrsHashIndex, digestAlgorithm, previousTimestamps));
        }
        timestampToken.getTimestampedReferences().addAll(timestampedReferences);
    }

    protected List<TimestampedReference> getArchiveTimestampOtherReferences(TimestampToken timestampToken) {
        return this.getSignatureSignedDataReferences();
    }

    private boolean isArchiveTimestampV2(TimestampToken timestampToken) {
        return ArchiveTimestampType.CAdES_V2.equals((Object)timestampToken.getArchiveTimestampType()) || ArchiveTimestampType.CAdES.equals((Object)timestampToken.getArchiveTimestampType());
    }

    private List<TimestampedReference> getSignedDataCertificateReferences(ASN1Sequence certsHashIndex, DigestAlgorithm digestAlgorithm) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        SignatureCertificateSource signatureCertificateSource = ((CAdESSignature)this.signature).getCertificateSource();
        if (signatureCertificateSource instanceof CMSCertificateSource) {
            List certsHashList = DSSASN1Utils.getDEROctetStrings((ASN1Sequence)certsHashIndex);
            for (CertificateToken certificate : signatureCertificateSource.getSignedDataCertificates()) {
                if (this.isDigestValuePresent(certificate.getDigest(digestAlgorithm), certsHashList)) {
                    this.addReference(references, (Identifier)certificate.getDSSId(), TimestampedObjectType.CERTIFICATE);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("The certificate with id [{}] was not included to the message imprint of timestamp or was added to the CMS SignedData after this ArchiveTimestamp has been incorporated!", (Object)certificate.getDSSIdAsString());
            }
        }
        return references;
    }

    private List<TimestampedReference> getSignedDataRevocationReferences(ASN1Sequence crlsHashIndex, DigestAlgorithm digestAlgorithm) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        List crlsHashList = DSSASN1Utils.getDEROctetStrings((ASN1Sequence)crlsHashIndex);
        this.addReferences(references, this.createReferencesForCRLBinaries(this.getSignedDataCRLBinaries(crlsHashList, digestAlgorithm)));
        this.addReferences(references, this.createReferencesForOCSPBinaries(this.getSignedDataOCSPResponseBinaries(crlsHashList, digestAlgorithm), this.certificateSource));
        return references;
    }

    private List<CRLBinary> getSignedDataCRLBinaries(List<DEROctetString> crlsHashList, DigestAlgorithm digestAlgorithm) {
        ArrayList<CRLBinary> crlBinaries = new ArrayList<CRLBinary>();
        OfflineCRLSource signatureCRLSource = ((CAdESSignature)this.signature).getCRLSource();
        if (signatureCRLSource instanceof CMSCRLSource) {
            CMSCRLSource cmsCRLSource = (CMSCRLSource)signatureCRLSource;
            for (EncapsulatedRevocationTokenIdentifier crlIdentifier : cmsCRLSource.getCMSSignedDataRevocationBinaries()) {
                CRLBinary crlBinary = (CRLBinary)crlIdentifier;
                if (this.isDigestValuePresent(crlBinary.getDigestValue(digestAlgorithm), crlsHashList)) {
                    crlBinaries.add(crlBinary);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("The CRL Token with id [{}] was not included to the message imprint of timestamp or was added to the CMS SignedData after this ArchiveTimestamp!", (Object)crlBinary.asXmlId());
            }
        }
        return crlBinaries;
    }

    private List<OCSPResponseBinary> getSignedDataOCSPResponseBinaries(List<DEROctetString> crlsHashList, DigestAlgorithm digestAlgorithm) {
        ArrayList<OCSPResponseBinary> ocspBinaries = new ArrayList<OCSPResponseBinary>();
        OfflineOCSPSource signatureOCSPSource = ((CAdESSignature)this.signature).getOCSPSource();
        if (signatureOCSPSource instanceof CMSOCSPSource) {
            CMSOCSPSource cmsOCSPSource = (CMSOCSPSource)signatureOCSPSource;
            for (EncapsulatedRevocationTokenIdentifier token : cmsOCSPSource.getCMSSignedDataRevocationBinaries()) {
                OCSPResponseBinary binary = (OCSPResponseBinary)token;
                OtherRevocationInfoFormat otherRevocationInfoFormat = new OtherRevocationInfoFormat(binary.getAsn1ObjectIdentifier(), (ASN1Encodable)DSSASN1Utils.toASN1Primitive((byte[])binary.getBasicOCSPRespContent()));
                DERTaggedObject derTaggedObject = new DERTaggedObject(false, 1, (ASN1Encodable)otherRevocationInfoFormat);
                if (this.isDigestValuePresent(DSSUtils.digest((DigestAlgorithm)digestAlgorithm, (byte[])DSSASN1Utils.getDEREncoded((ASN1Encodable)derTaggedObject)), crlsHashList)) {
                    ocspBinaries.add(binary);
                    continue;
                }
                LOG.warn("The OCSP Token with id [{}] was not included to the message imprint of timestamp or was added to the CMS SignedData after this ArchiveTimestamp!", (Object)binary.asXmlId());
            }
        }
        return ocspBinaries;
    }

    private List<TimestampedReference> getUnsignedAttributesReferences(ASN1Sequence unsignedAttrsHashIndex, DigestAlgorithm digestAlgorithm, List<TimestampToken> previousTimestamps) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        List timestampUnsignedAttributesHashesList = DSSASN1Utils.getDEROctetStrings((ASN1Sequence)unsignedAttrsHashIndex);
        SignatureProperties unsignedSignatureProperties = this.getUnsignedSignatureProperties();
        for (CAdESAttribute unsignedAttribute : unsignedSignatureProperties.getAttributes()) {
            List octets = DSSASN1Utils.getATSHashIndexV3OctetString((ASN1ObjectIdentifier)unsignedAttribute.getASN1Oid(), (ASN1Set)unsignedAttribute.getAttrValues());
            for (byte[] bytes : octets) {
                byte[] digest = DSSUtils.digest((DigestAlgorithm)digestAlgorithm, (byte[])bytes);
                DEROctetString derDigest = new DEROctetString(digest);
                if (!timestampUnsignedAttributesHashesList.contains(derDigest)) continue;
                this.addReferences(references, this.getReferencesFromUnsignedProperty(unsignedAttribute, previousTimestamps));
            }
        }
        return references;
    }

    private List<TimestampedReference> getReferencesFromUnsignedProperty(CAdESAttribute unsignedAttribute, List<TimestampToken> previousTimestamps) {
        if (unsignedAttribute.isTimeStampToken()) {
            List<TimestampedReference> references = this.getReferencesFromMatchingTimestamp(unsignedAttribute, previousTimestamps);
            if (Utils.isCollectionEmpty(references)) {
                LOG.warn("The timestamp order is broken! Unable to find a covered timestamp.");
            }
            return references;
        }
        if (this.isCompleteCertificateRef(unsignedAttribute) || this.isAttributeCertificateRef(unsignedAttribute)) {
            return this.getTimestampedCertificateRefs(unsignedAttribute);
        }
        if (this.isCompleteRevocationRef(unsignedAttribute) || this.isAttributeRevocationRef(unsignedAttribute)) {
            return this.getTimestampedRevocationRefs(unsignedAttribute);
        }
        if (this.isCertificateValues(unsignedAttribute)) {
            return this.getTimestampedCertificateValues(unsignedAttribute);
        }
        if (this.isRevocationValues(unsignedAttribute)) {
            return this.getTimestampedRevocationValues(unsignedAttribute);
        }
        if (this.isCounterSignature(unsignedAttribute)) {
            List<AdvancedSignature> counterSignatures = this.getCounterSignatures(unsignedAttribute);
            return this.getCounterSignaturesReferences(counterSignatures);
        }
        LOG.warn("Unable to find an unsigned attribute with the digest from ats-hash-index-v3");
        return Collections.emptyList();
    }

    private List<TimestampedReference> getReferencesFromMatchingTimestamp(CAdESAttribute unsignedAttribute, List<TimestampToken> previousTimestamps) {
        ASN1Encodable asn1Object = unsignedAttribute.getASN1Object();
        byte[] derEncoded = DSSASN1Utils.getDEREncoded((ASN1Encodable)asn1Object);
        for (TimestampToken timestampToken : previousTimestamps) {
            if (!Arrays.equals(derEncoded, timestampToken.getEncoded())) continue;
            return this.getReferencesFromTimestamp(timestampToken, this.certificateSource, this.crlSource, this.ocspSource);
        }
        return Collections.emptyList();
    }

    protected List<TimestampedReference> getSignatureSignedDataReferences() {
        OfflineOCSPSource signatureOCSPSource;
        OfflineCRLSource signatureCRLSource;
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        SignatureCertificateSource signatureCertificateSource = ((CAdESSignature)this.signature).getCertificateSource();
        if (signatureCertificateSource instanceof CMSCertificateSource) {
            this.addReferences(references, this.createReferencesForCertificates(signatureCertificateSource.getSignedDataCertificates()));
        }
        if ((signatureCRLSource = ((CAdESSignature)this.signature).getCRLSource()) instanceof CMSCRLSource) {
            this.addReferences(references, this.createReferencesForCRLBinaries(signatureCRLSource.getCMSSignedDataRevocationBinaries()));
        }
        if ((signatureOCSPSource = ((CAdESSignature)this.signature).getOCSPSource()) instanceof CMSOCSPSource) {
            this.addReferences(references, this.createReferencesForOCSPBinaries(signatureOCSPSource.getCMSSignedDataRevocationBinaries(), this.certificateSource));
        }
        return references;
    }

    private DigestAlgorithm getHashIndexDigestAlgorithm(ASN1Sequence atsHashIndex) {
        AlgorithmIdentifier algorithmIdentifier = DSSASN1Utils.getAlgorithmIdentifier((ASN1Sequence)atsHashIndex);
        return algorithmIdentifier != null ? DigestAlgorithm.forOID((String)algorithmIdentifier.getAlgorithm().getId()) : CMSUtils.DEFAULT_ARCHIVE_TIMESTAMP_HASH_ALGO;
    }

    private boolean isDigestValuePresent(byte[] digestValue, List<DEROctetString> hashList) {
        return hashList.contains(new DEROctetString(digestValue));
    }

    protected List<CertificateRef> getCertificateRefs(CAdESAttribute unsignedAttribute) {
        ArrayList<CertificateRef> certRefs = new ArrayList<CertificateRef>();
        ASN1Sequence seq = (ASN1Sequence)unsignedAttribute.getASN1Object();
        for (int ii = 0; ii < seq.size(); ++ii) {
            OtherCertID otherCertId = OtherCertID.getInstance((Object)seq.getObjectAt(ii));
            certRefs.add(DSSASN1Utils.getCertificateRef((OtherCertID)otherCertId));
        }
        return certRefs;
    }

    protected List<CRLRef> getCRLRefs(CAdESAttribute unsignedAttribute) {
        ArrayList<CRLRef> refs = new ArrayList<CRLRef>();
        ASN1Sequence seq = (ASN1Sequence)unsignedAttribute.getASN1Object();
        for (int ii = 0; ii < seq.size(); ++ii) {
            CrlOcspRef otherRefId = CrlOcspRef.getInstance((Object)seq.getObjectAt(ii));
            CrlListID otherCrlIds = otherRefId.getCrlids();
            if (otherCrlIds == null) continue;
            for (CrlValidatedID id : otherCrlIds.getCrls()) {
                refs.add(new CRLRef(id));
            }
        }
        return refs;
    }

    protected List<OCSPRef> getOCSPRefs(CAdESAttribute unsignedAttribute) {
        ArrayList<OCSPRef> refs = new ArrayList<OCSPRef>();
        ASN1Sequence seq = (ASN1Sequence)unsignedAttribute.getASN1Object();
        for (int i = 0; i < seq.size(); ++i) {
            CrlOcspRef otherCertId = CrlOcspRef.getInstance((Object)seq.getObjectAt(i));
            OcspListID ocspListID = otherCertId.getOcspids();
            if (ocspListID == null) continue;
            for (OcspResponsesID ocspResponsesID : ocspListID.getOcspResponses()) {
                refs.add(new OCSPRef(ocspResponsesID));
            }
        }
        return refs;
    }

    protected List<Identifier> getEncapsulatedCertificateIdentifiers(CAdESAttribute unsignedAttribute) {
        ArrayList<Identifier> certificateIdentifiers = new ArrayList<Identifier>();
        ASN1Sequence seq = (ASN1Sequence)unsignedAttribute.getASN1Object();
        for (int ii = 0; ii < seq.size(); ++ii) {
            try {
                Certificate cs = Certificate.getInstance((Object)seq.getObjectAt(ii));
                CertificateToken certificateToken = DSSUtils.loadCertificate((byte[])cs.getEncoded());
                certificateIdentifiers.add((Identifier)certificateToken.getDSSId());
                continue;
            }
            catch (Exception e) {
                String errorMessage = "Unable to parse an encapsulated certificate : {}";
                if (LOG.isDebugEnabled()) {
                    LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                    continue;
                }
                LOG.warn(errorMessage, (Object)e.getMessage());
            }
        }
        return certificateIdentifiers;
    }

    protected List<CRLBinary> getEncapsulatedCRLIdentifiers(CAdESAttribute unsignedAttribute) {
        ASN1Encodable asn1Object = unsignedAttribute.getASN1Object();
        RevocationValues revocationValues = DSSASN1Utils.getRevocationValues((ASN1Encodable)asn1Object);
        if (revocationValues != null) {
            return this.buildCRLIdentifiers(revocationValues.getCrlVals());
        }
        return Collections.emptyList();
    }

    protected List<CRLBinary> buildCRLIdentifiers(CertificateList ... crlVals) {
        ArrayList<CRLBinary> crlBinaryIdentifiers = new ArrayList<CRLBinary>();
        if (Utils.isArrayNotEmpty((Object[])crlVals)) {
            for (CertificateList revValue : crlVals) {
                try {
                    crlBinaryIdentifiers.add(CRLUtils.buildCRLBinary((byte[])revValue.getEncoded()));
                }
                catch (Exception e) {
                    String errorMessage = "Unable to parse CRL binaries : {}";
                    if (LOG.isDebugEnabled()) {
                        LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                        continue;
                    }
                    LOG.warn(errorMessage, (Object)e.getMessage());
                }
            }
        }
        return crlBinaryIdentifiers;
    }

    protected List<OCSPResponseBinary> getEncapsulatedOCSPIdentifiers(CAdESAttribute unsignedAttribute) {
        ASN1Encodable asn1Object = unsignedAttribute.getASN1Object();
        RevocationValues revocationValues = DSSASN1Utils.getRevocationValues((ASN1Encodable)asn1Object);
        if (revocationValues != null) {
            return this.buildOCSPIdentifiers(DSSASN1Utils.toBasicOCSPResps((BasicOCSPResponse[])revocationValues.getOcspVals()));
        }
        return Collections.emptyList();
    }

    protected List<OCSPResponseBinary> buildOCSPIdentifiers(BasicOCSPResp ... ocspVals) {
        ArrayList<OCSPResponseBinary> ocspIdentifiers = new ArrayList<OCSPResponseBinary>();
        if (Utils.isArrayNotEmpty((Object[])ocspVals)) {
            for (BasicOCSPResp basicOCSPResp : ocspVals) {
                try {
                    ocspIdentifiers.add(OCSPResponseBinary.build((BasicOCSPResp)basicOCSPResp));
                }
                catch (Exception e) {
                    String errorMessage = "Unable to parse OCSP response binaries : {}";
                    if (LOG.isDebugEnabled()) {
                        LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
                        continue;
                    }
                    LOG.warn(errorMessage, (Object)e.getMessage());
                }
            }
        }
        return ocspIdentifiers;
    }

    protected ArchiveTimestampType getArchiveTimestampType(CAdESAttribute unsignedAttribute) {
        if (OID.id_aa_ets_archiveTimestampV2.equals((ASN1Primitive)unsignedAttribute.getASN1Oid())) {
            return ArchiveTimestampType.CAdES_V2;
        }
        if (OID.id_aa_ets_archiveTimestampV3.equals((ASN1Primitive)unsignedAttribute.getASN1Oid())) {
            return ArchiveTimestampType.CAdES_V3;
        }
        return ArchiveTimestampType.CAdES;
    }

    protected List<AdvancedSignature> getCounterSignatures(CAdESAttribute unsignedAttribute) {
        ArrayList<AdvancedSignature> cadesResult = new ArrayList<AdvancedSignature>();
        List<AdvancedSignature> allCounterSignatures = ((CAdESSignature)this.signature).getCounterSignatures();
        ASN1Set attrValues = unsignedAttribute.getAttrValues();
        Enumeration en = attrValues.getObjects();
        while (en.hasMoreElements()) {
            SignerInfo si = SignerInfo.getInstance(en.nextElement());
            byte[] encodedSI = DSSASN1Utils.getDEREncoded((ASN1Encodable)si);
            for (AdvancedSignature counterSignature : allCounterSignatures) {
                CAdESSignature cadesCounterSignature = (CAdESSignature)counterSignature;
                SignerInfo signerInfo = cadesCounterSignature.getSignerInformation().toASN1Structure();
                byte[] encodedSignerInfo = DSSASN1Utils.getDEREncoded((ASN1Encodable)signerInfo);
                if (!Arrays.equals(encodedSI, encodedSignerInfo)) continue;
                cadesResult.add(counterSignature);
            }
        }
        return cadesResult;
    }

    protected List<TimestampedReference> getCounterSignatureReferences(AdvancedSignature counterSignature) {
        ArrayList<TimestampedReference> counterSigReferences = new ArrayList<TimestampedReference>();
        counterSigReferences.add(new TimestampedReference(counterSignature.getId(), TimestampedObjectType.SIGNATURE));
        List signingCertificateRefs = counterSignature.getCertificateSource().getSigningCertificateRefs();
        this.addReferences(counterSigReferences, this.createReferencesForCertificateRefs(signingCertificateRefs, (CertificateSource)counterSignature.getCertificateSource(), this.certificateSource));
        TimestampSource counterSignatureTimestampSource = counterSignature.getTimestampSource();
        this.addReferences(counterSigReferences, counterSignatureTimestampSource.getSignerDataReferences());
        this.addReferences(counterSigReferences, counterSignatureTimestampSource.getUnsignedPropertiesReferences());
        this.addReferences(counterSigReferences, this.getEncapsulatedReferencesFromTimestamps(counterSignatureTimestampSource.getAllTimestamps()));
        return counterSigReferences;
    }
}

