/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation.scope;

import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.identifier.IdentifierBasedObject;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.ReferenceValidation;
import eu.europa.esig.dss.validation.scope.AbstractSignatureScopeFinder;
import eu.europa.esig.dss.validation.scope.CounterSignatureScope;
import eu.europa.esig.dss.validation.scope.DigestSignatureScope;
import eu.europa.esig.dss.validation.scope.FullSignatureScope;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import eu.europa.esig.dss.validation.scope.SignatureScopeFinder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESSignatureScopeFinder
extends AbstractSignatureScopeFinder
implements SignatureScopeFinder<CAdESSignature> {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESSignatureScopeFinder.class);

    public List<SignatureScope> findSignatureScope(CAdESSignature cadesSignature) {
        List<ReferenceValidation> referenceValidations = cadesSignature.getReferenceValidations();
        if (Utils.isCollectionNotEmpty(referenceValidations)) {
            ReferenceValidation reference = referenceValidations.iterator().next();
            if (reference.isIntact()) {
                DSSDocument originalDocument = this.getOriginalDocument(cadesSignature);
                return this.getSignatureScopeFromOriginalDocument(cadesSignature, originalDocument);
            }
            if (reference.isFound()) {
                return this.getSignatureScopeFromReferenceValidation(reference);
            }
        }
        return Collections.emptyList();
    }

    protected List<SignatureScope> getSignatureScopeFromOriginalDocument(CAdESSignature cadesSignature, DSSDocument originalDocument) {
        ArrayList<SignatureScope> result = new ArrayList<SignatureScope>();
        if (originalDocument == null) {
            return result;
        }
        String fileName = originalDocument.getName();
        if (cadesSignature.isCounterSignature()) {
            return Collections.singletonList(new CounterSignatureScope(this.getTokenIdentifierProvider().getIdAsString((IdentifierBasedObject)cadesSignature.getMasterSignature()), this.getDigest(originalDocument)));
        }
        if (originalDocument instanceof DigestDocument) {
            DigestDocument digestDocument = (DigestDocument)originalDocument;
            result.add((SignatureScope)new DigestSignatureScope(fileName != null ? fileName : "Digest document", digestDocument.getExistingDigest()));
        } else {
            result.add((SignatureScope)new FullSignatureScope(fileName != null ? fileName : "Full document", this.getDigest(originalDocument)));
        }
        return result;
    }

    protected List<SignatureScope> getSignatureScopeFromReferenceValidation(ReferenceValidation reference) {
        ArrayList<SignatureScope> result = new ArrayList<SignatureScope>();
        result.add((SignatureScope)new FullSignatureScope("Full document", reference.getDigest()));
        return result;
    }

    protected DSSDocument getOriginalDocument(CAdESSignature cadesSignature) {
        try {
            return cadesSignature.getOriginalDocument();
        }
        catch (DSSException e) {
            LOG.warn("A CAdES signer's original document is not found [{}].", (Object)e.getMessage());
            return null;
        }
    }
}

