/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.model.CommonDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.cms.CMSSignedData;

public class CMSSignedDocument
extends CommonDocument {
    private static final long serialVersionUID = 1413370170096318058L;
    protected CMSSignedData signedData;

    public CMSSignedDocument(CMSSignedData data) {
        this(data, null);
    }

    public CMSSignedDocument(CMSSignedData data, String name) {
        Objects.requireNonNull(data, "The CMSSignedData cannot be null");
        this.signedData = data;
        this.name = name;
        this.mimeType = MimeType.PKCS7;
    }

    public InputStream openStream() {
        return new ByteArrayInputStream(this.getBytes());
    }

    public CMSSignedData getCMSSignedData() {
        return this.signedData;
    }

    public byte[] getBytes() {
        byte[] byArray;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            this.writeTo(output);
            byArray = output.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException(String.format("An error occurred while reading CMSSignedData binaries : %s", e.getMessage()), (Throwable)e);
            }
        }
        output.close();
        return byArray;
    }

    public void writeTo(OutputStream stream) throws IOException {
        byte[] encoded = this.signedData.getEncoded();
        ASN1Primitive asn1Primitive = DSSASN1Utils.toASN1Primitive((byte[])encoded);
        ASN1OutputStream asn1OutputStream = ASN1OutputStream.create((OutputStream)stream, (String)"DER");
        asn1OutputStream.writeObject(asn1Primitive);
    }
}

