/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.signature;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.AbstractASiCFilenameFactory;
import eu.europa.esig.dss.asic.xades.signature.ASiCWithXAdESFilenameFactory;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import java.util.List;

public class DefaultASiCWithXAdESFilenameFactory
extends AbstractASiCFilenameFactory
implements ASiCWithXAdESFilenameFactory {
    private static final long serialVersionUID = -3252975270136045191L;

    @Override
    public String getSignatureFilename(ASiCContent asicContent) {
        this.assertASiCContentIsValid(asicContent);
        if (ASiCUtils.isASiCSContainer((ASiCContent)asicContent)) {
            return "META-INF/signatures.xml";
        }
        if (ASiCUtils.isOpenDocument((DSSDocument)asicContent.getMimeTypeDocument())) {
            return "META-INF/documentsignatures.xml";
        }
        List existingSignatureNames = DSSUtils.getDocumentNames((List)asicContent.getSignatureDocuments());
        return this.getNextAvailableDocumentName("META-INF/signatures001.xml", existingSignatureNames);
    }

    @Override
    public String getManifestFilename(ASiCContent asicContent) {
        return "META-INF/manifest.xml";
    }

    @Override
    public String getDataPackageFilename(ASiCContent asicContent) {
        return "package.zip";
    }
}

