/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.signature;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.signature.AbstractASiCDataToSignHelperBuilder;
import eu.europa.esig.dss.asic.xades.ASiCWithXAdESSignatureParameters;
import eu.europa.esig.dss.asic.xades.signature.ASiCWithXAdESFilenameFactory;
import eu.europa.esig.dss.asic.xades.signature.GetDataToSignASiCWithXAdESHelper;
import eu.europa.esig.dss.asic.xades.signature.asice.ASiCEWithXAdESManifestBuilder;
import eu.europa.esig.dss.asic.xades.signature.asice.DataToSignASiCEWithXAdESHelper;
import eu.europa.esig.dss.asic.xades.signature.asice.DataToSignOpenDocumentHelper;
import eu.europa.esig.dss.asic.xades.signature.asics.DataToSignASiCSWithXAdESHelper;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collection;
import java.util.Collections;

public class ASiCWithXAdESDataToSignHelperBuilder
extends AbstractASiCDataToSignHelperBuilder {
    protected final ASiCWithXAdESFilenameFactory asicFilenameFactory;

    public ASiCWithXAdESDataToSignHelperBuilder(ASiCWithXAdESFilenameFactory asicFilenameFactory) {
        this.asicFilenameFactory = asicFilenameFactory;
    }

    public GetDataToSignASiCWithXAdESHelper build(ASiCContent asicContent, ASiCWithXAdESSignatureParameters parameters) {
        if (ASiCUtils.isOpenDocument((DSSDocument)(asicContent = ASiCUtils.ensureMimeTypeAndZipComment((ASiCContent)asicContent, (ASiCParameters)parameters.aSiC())).getMimeTypeDocument())) {
            return new DataToSignOpenDocumentHelper(asicContent);
        }
        if (Utils.isCollectionNotEmpty((Collection)asicContent.getSignatureDocuments())) {
            ASiCContainerType currentContainerType = asicContent.getContainerType();
            boolean asice = ASiCUtils.isASiCE((ASiCParameters)parameters.aSiC());
            if (asice && ASiCContainerType.ASiC_E.equals((Object)currentContainerType)) {
                return new DataToSignASiCEWithXAdESHelper(asicContent);
            }
            if (!asice && ASiCContainerType.ASiC_S.equals((Object)currentContainerType)) {
                return new DataToSignASiCSWithXAdESHelper(asicContent);
            }
            throw new UnsupportedOperationException(String.format("Original container type '%s' vs parameter : '%s'", currentContainerType, parameters.aSiC().getContainerType()));
        }
        return this.fromFiles(asicContent, parameters);
    }

    private GetDataToSignASiCWithXAdESHelper fromFiles(ASiCContent asicContent, ASiCWithXAdESSignatureParameters parameters) {
        if (ASiCUtils.isASiCE((ASiCParameters)parameters.aSiC())) {
            DSSDocument asicManifest = this.createASiCManifest(asicContent);
            asicContent.getManifestDocuments().add(asicManifest);
            return new DataToSignASiCEWithXAdESHelper(asicContent);
        }
        DSSDocument asicsSignedDocument = this.getASiCSSignedDocument(asicContent.getSignedDocuments(), parameters.bLevel().getSigningDate());
        asicContent.setSignedDocuments(Collections.singletonList(asicsSignedDocument));
        return new DataToSignASiCSWithXAdESHelper(asicContent);
    }

    private DSSDocument createASiCManifest(ASiCContent asicContent) {
        return new ASiCEWithXAdESManifestBuilder().setDocuments(asicContent.getSignedDocuments()).setManifestFilename(this.asicFilenameFactory.getManifestFilename(asicContent)).build();
    }

    protected String getDataPackageName(ASiCContent asicContent) {
        return this.asicFilenameFactory.getDataPackageFilename(asicContent);
    }
}

