/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.merge;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.ZipUtils;
import eu.europa.esig.dss.asic.xades.merge.AbstractASiCWithXAdESContainerMerger;
import eu.europa.esig.dss.asic.xades.signature.asice.ASiCEWithXAdESManifestBuilder;
import eu.europa.esig.dss.asic.xades.validation.ASiCEWithXAdESManifestParser;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.ManifestEntry;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.XMLDocumentValidator;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.xml.security.signature.Reference;

public class ASiCEWithXAdESContainerMerger
extends AbstractASiCWithXAdESContainerMerger {
    ASiCEWithXAdESContainerMerger() {
    }

    public ASiCEWithXAdESContainerMerger(DSSDocument ... containers) {
        super(containers);
    }

    public ASiCEWithXAdESContainerMerger(ASiCContent ... asicContents) {
        super(asicContents);
    }

    @Override
    protected boolean isSupported(DSSDocument container) {
        return super.isSupported(container) && (!ASiCUtils.isASiCSContainer((DSSDocument)container) || this.doesNotContainSignatures(container));
    }

    private boolean doesNotContainSignatures(DSSDocument container) {
        List entryNames = ZipUtils.getInstance().extractEntryNames(container);
        return !ASiCUtils.filesContainSignatures((List)entryNames);
    }

    @Override
    protected boolean isSupported(ASiCContent asicContent) {
        return super.isSupported(asicContent) && (!ASiCUtils.isASiCSContainer((ASiCContent)asicContent) || this.doesNotContainSignatures(asicContent));
    }

    private boolean doesNotContainSignatures(ASiCContent asicContent) {
        return Utils.isCollectionEmpty((Collection)asicContent.getSignatureDocuments());
    }

    protected ASiCContainerType getTargetASiCContainerType() {
        return ASiCContainerType.ASiC_E;
    }

    protected void ensureContainerContentAllowMerge() {
        if (Arrays.stream(this.asicContents).allMatch(asicContent -> Utils.isCollectionEmpty((Collection)asicContent.getSignatureDocuments()))) {
            return;
        }
        if (Arrays.stream(this.asicContents).anyMatch(asicContent -> Utils.isCollectionNotEmpty((Collection)asicContent.getTimestampDocuments()))) {
            throw new UnsupportedOperationException("Unable to merge ASiC-E with XAdES containers. One of the containers contains a detached timestamp!");
        }
    }

    protected void ensureSignaturesAllowMerge() {
        if (Arrays.stream(this.asicContents).filter(asicContent -> Utils.isCollectionNotEmpty((Collection)asicContent.getSignatureDocuments())).count() <= 1L) {
            return;
        }
        List<String> documentsCoveredBySignatures = this.getCoveredDocumentNames();
        if (Arrays.stream(this.asicContents).anyMatch(asicContent -> this.doCoverManifest(documentsCoveredBySignatures)) && !this.sameSignedDocuments()) {
            throw new UnsupportedOperationException("Unable to merge ASiC-E with XAdES containers. manifest.xml is signed and the signer data does not match between containers!");
        }
        List<String> signatureNames = this.getAllSignatureDocumentNames();
        if (this.isConflictBetweenSignatureDocumentNames(signatureNames)) {
            if (this.doCoverOtherSignatures(signatureNames, documentsCoveredBySignatures)) {
                throw new UnsupportedOperationException("Unable to merge ASiC-E with XAdES containers. A signature covers another signature file, while having same signature names in both containers!");
            }
            this.ensureSignatureNamesDiffer();
        }
        DSSDocument newManifest = this.createNewManifest();
        for (ASiCContent asicContent2 : this.asicContents) {
            asicContent2.setManifestDocuments(Collections.singletonList(newManifest));
        }
    }

    private List<String> getCoveredDocumentNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ASiCContent asicContent : this.asicContents) {
            for (DSSDocument signatureDocument : asicContent.getSignatureDocuments()) {
                XMLDocumentValidator documentValidator = new XMLDocumentValidator(signatureDocument);
                for (AdvancedSignature signature : documentValidator.getSignatures()) {
                    result.addAll(this.getCoveredDocumentNames((XAdESSignature)signature));
                }
            }
        }
        return result;
    }

    private List<String> getCoveredDocumentNames(XAdESSignature signature) {
        ArrayList<String> result = new ArrayList<String>();
        for (Reference reference : signature.getReferences()) {
            String referenceURI = DSSXMLUtils.getReferenceURI((Reference)reference);
            if (DomUtils.startsFromHash((String)referenceURI) || DomUtils.isXPointerQuery((String)referenceURI)) continue;
            result.add(referenceURI);
        }
        return result;
    }

    private boolean doCoverManifest(List<String> documentNames) {
        return documentNames.contains("META-INF/manifest.xml");
    }

    private boolean sameSignedDocuments() {
        HashSet signedDocumentNames = null;
        for (ASiCContent asicContent : this.asicContents) {
            HashSet currentSignedDocumentNames = new HashSet(DSSUtils.getDocumentNames((List)asicContent.getSignedDocuments()));
            if (signedDocumentNames == null) {
                signedDocumentNames = currentSignedDocumentNames;
                continue;
            }
            if (signedDocumentNames.equals(currentSignedDocumentNames)) continue;
            return false;
        }
        return true;
    }

    private List<String> getAllSignatureDocumentNames() {
        ArrayList<String> signatureDocumentNames = new ArrayList<String>();
        for (ASiCContent asicContent : this.asicContents) {
            signatureDocumentNames.addAll(DSSUtils.getDocumentNames((List)asicContent.getSignatureDocuments()));
        }
        return signatureDocumentNames;
    }

    private boolean isConflictBetweenSignatureDocumentNames(List<String> signatureDocumentNames) {
        for (String signatureDocumentName : signatureDocumentNames) {
            if (Collections.frequency(signatureDocumentNames, signatureDocumentName) <= 1) continue;
            return true;
        }
        return false;
    }

    private boolean doCoverOtherSignatures(List<String> signatureNames, List<String> coveredDocumentNames) {
        for (String signature : signatureNames) {
            if (!coveredDocumentNames.contains(signature)) continue;
            return true;
        }
        return false;
    }

    private DSSDocument createNewManifest() {
        ArrayList<ManifestEntry> manifestEntries = new ArrayList<ManifestEntry>();
        ArrayList<String> addedFileNames = new ArrayList<String>();
        ASiCContent mergedContent = this.createEmptyContainer();
        for (ASiCContent asicContent : this.asicContents) {
            List manifestDocuments = asicContent.getManifestDocuments();
            mergedContent.getManifestDocuments().addAll(manifestDocuments);
            for (ManifestEntry entry : this.getManifestFileEntries(manifestDocuments)) {
                if (addedFileNames.contains(entry.getFileName())) continue;
                manifestEntries.add(entry);
                addedFileNames.add(entry.getFileName());
            }
            List signedDocuments = asicContent.getSignedDocuments();
            for (ManifestEntry entry : ASiCUtils.toSimpleManifestEntries((List)signedDocuments)) {
                if (addedFileNames.contains(entry.getFileName())) continue;
                manifestEntries.add(entry);
                addedFileNames.add(entry.getFileName());
            }
        }
        return this.createNewManifestXml(manifestEntries, mergedContent);
    }

    private List<ManifestEntry> getManifestFileEntries(List<DSSDocument> manifestDocuments) {
        if (Utils.isCollectionEmpty(manifestDocuments)) {
            return Collections.emptyList();
        }
        if (Utils.collectionSize(manifestDocuments) > 1) {
            throw new IllegalInputException("One of the containers contain multiple manifest files!");
        }
        DSSDocument manifestDocument = manifestDocuments.get(0);
        if (!"META-INF/manifest.xml".equals(manifestDocument.getName())) {
            throw new IllegalInputException(String.format("A manifest file shall have a name '%s'.", "META-INF/manifest.xml"));
        }
        ASiCEWithXAdESManifestParser parser = new ASiCEWithXAdESManifestParser(manifestDocument);
        ManifestFile manifest = parser.getManifest();
        return manifest.getEntries();
    }

    private DSSDocument createNewManifestXml(List<ManifestEntry> manifestEntries, ASiCContent asicContent) {
        return new ASiCEWithXAdESManifestBuilder().setEntries(manifestEntries).setManifestFilename(this.asicFilenameFactory.getManifestFilename(asicContent)).build();
    }

    private void ensureSignatureNamesDiffer() {
        HashSet<String> usedSignatureNames = new HashSet<String>();
        ASiCContent mergedASiCContent = this.createEmptyContainer();
        for (ASiCContent asicContent : this.asicContents) {
            mergedASiCContent.getSignatureDocuments().addAll(asicContent.getSignatureDocuments());
        }
        for (ASiCContent asicContent : this.asicContents) {
            List signatureDocuments = asicContent.getSignatureDocuments();
            for (DSSDocument signatureDocument : signatureDocuments) {
                if (usedSignatureNames.contains(signatureDocument.getName())) {
                    String newSignatureName = this.asicFilenameFactory.getSignatureFilename(mergedASiCContent);
                    signatureDocument.setName(newSignatureName);
                }
                usedSignatureNames.add(signatureDocument.getName());
            }
        }
    }
}

