/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.signature.asice;

import eu.europa.esig.dss.asic.xades.signature.GetDataToSignASiCWithXAdESHelper;
import eu.europa.esig.dss.asic.xades.signature.asice.AbstractDataToSignASiCEWithXAdES;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class DataToSignOpenDocument
extends AbstractDataToSignASiCEWithXAdES
implements GetDataToSignASiCWithXAdESHelper {
    private static final String ZIP_OPEN_DOCUMENT_METAINF_XADES_SIGNATURE = "META-INF/documentsignatures.xml";
    private final List<DSSDocument> signedDocuments;
    private final List<DSSDocument> existingSignatures;
    private final List<DSSDocument> existingManifests;
    private final DSSDocument mimetype;
    private final DSSDocument rootContainer;

    public DataToSignOpenDocument(List<DSSDocument> signedDocuments, List<DSSDocument> existingSignatures, List<DSSDocument> existingManifests, DSSDocument mimetype, DSSDocument rootContainer) {
        this.signedDocuments = signedDocuments;
        this.existingSignatures = existingSignatures;
        this.existingManifests = existingManifests;
        this.mimetype = mimetype;
        this.rootContainer = rootContainer;
    }

    public String getSignatureFilename() {
        return ZIP_OPEN_DOCUMENT_METAINF_XADES_SIGNATURE;
    }

    public String getTimestampFilename() {
        throw new UnsupportedOperationException("Timestamp file cannot be added with ASiC-E + XAdES");
    }

    @Override
    public List<DSSDocument> getToBeSigned() {
        return this.signedDocuments;
    }

    @Override
    public DSSDocument getExistingSignature() {
        int nbEmbeddedSignatures = Utils.collectionSize(this.existingSignatures);
        if (nbEmbeddedSignatures == 1) {
            return this.existingSignatures.get(0);
        }
        return null;
    }

    public List<DSSDocument> getSignedDocuments() {
        ArrayList<DSSDocument> docs = new ArrayList<DSSDocument>();
        for (DSSDocument doc : this.signedDocuments) {
            if (doc.getName().startsWith("external-data/")) continue;
            docs.add(doc);
        }
        docs.addAll(this.existingManifests);
        docs.add(this.mimetype);
        return docs;
    }

    public List<DSSDocument> getManifestFiles() {
        return this.existingManifests;
    }

    public List<DSSDocument> getSignatures() {
        return this.existingSignatures;
    }

    @Override
    public DSSDocument getRootDocument() {
        return this.rootContainer;
    }
}

