/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.signature.asics;

import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.xades.signature.GetDataToSignASiCWithXAdESHelper;
import eu.europa.esig.dss.asic.xades.signature.asics.AbstractGetDataToSignASiCSWithXAdES;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class DataToSignASiCSWithXAdESFromFiles
extends AbstractGetDataToSignASiCSWithXAdES
implements GetDataToSignASiCWithXAdESHelper {
    private final List<DSSDocument> filesToBeSigned;
    private final Date signingDate;
    private final ASiCParameters asicParameters;
    private List<DSSDocument> signedDocuments;

    public DataToSignASiCSWithXAdESFromFiles(List<DSSDocument> filesToBeSigned, Date signingDate, ASiCParameters asicParameters) {
        this.filesToBeSigned = filesToBeSigned;
        this.signingDate = signingDate;
        this.asicParameters = asicParameters;
    }

    public String getSignatureFilename() {
        return this.getSignatureFileName(this.asicParameters);
    }

    public String getTimestampFilename() {
        throw new UnsupportedOperationException("Timestamp file cannot be added with ASiC-S + XAdES");
    }

    @Override
    public List<DSSDocument> getToBeSigned() {
        return this.getSignedDocuments();
    }

    @Override
    public DSSDocument getExistingSignature() {
        return null;
    }

    public List<DSSDocument> getSignedDocuments() {
        if (this.signedDocuments == null) {
            if (Utils.collectionSize(this.filesToBeSigned) > 1) {
                DSSDocument packageZip = this.createPackageZip(this.filesToBeSigned, this.signingDate, ASiCUtils.getZipComment((ASiCParameters)this.asicParameters));
                this.signedDocuments = Arrays.asList(packageZip);
            } else {
                this.signedDocuments = new ArrayList<DSSDocument>(this.filesToBeSigned);
            }
        }
        return this.signedDocuments;
    }

    public List<DSSDocument> getManifestFiles() {
        return Collections.emptyList();
    }

    public List<DSSDocument> getSignatures() {
        return new ArrayList<DSSDocument>();
    }

    @Override
    public DSSDocument getRootDocument() {
        return null;
    }
}

