/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.validation;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.asic.xades.definition.ManifestNamespace;
import eu.europa.esig.dss.asic.xades.definition.ManifestPaths;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.ManifestEntry;
import eu.europa.esig.dss.validation.ManifestFile;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ASiCEWithXAdESManifestParser {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCEWithXAdESManifestParser.class);
    private final DSSDocument signatureDocument;
    private final DSSDocument manifestDocument;

    public ASiCEWithXAdESManifestParser(DSSDocument signatureDocument, DSSDocument manifestDocument) {
        this.signatureDocument = signatureDocument;
        this.manifestDocument = manifestDocument;
    }

    public ManifestFile getManifest() {
        ManifestFile manifest = new ManifestFile();
        manifest.setDocument(this.manifestDocument);
        manifest.setSignatureFilename(this.signatureDocument.getName());
        manifest.setEntries(this.getEntries());
        return manifest;
    }

    private List<ManifestEntry> getEntries() {
        ArrayList<ManifestEntry> result = new ArrayList<ManifestEntry>();
        try (InputStream is = this.manifestDocument.openStream();){
            Document manifestDom = DomUtils.buildDOM((InputStream)is);
            NodeList nodeList = DomUtils.getNodeList((Node)manifestDom, (String)ManifestPaths.FILE_ENTRY_PATH);
            if (nodeList != null && nodeList.getLength() > 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    ManifestEntry manifestEntry = new ManifestEntry();
                    Element fileEntryElement = (Element)nodeList.item(i);
                    String fullpathValue = fileEntryElement.getAttribute(ManifestPaths.FULL_PATH_ATTRIBUTE);
                    if (this.isFolder(fullpathValue)) continue;
                    manifestEntry.setFileName(fullpathValue);
                    manifestEntry.setMimeType(ASiCEWithXAdESManifestParser.getMimeType(fileEntryElement));
                    result.add(manifestEntry);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Unable to parse manifest file '{}'", (Object)this.manifestDocument.getName(), (Object)e);
        }
        return result;
    }

    private static MimeType getMimeType(Element fileEntryElement) {
        String mediaType = fileEntryElement.getAttribute(ManifestPaths.MEDIA_TYPE_ATTRIBUTE);
        if (Utils.isStringNotBlank((String)mediaType)) {
            return MimeType.fromMimeTypeString((String)mediaType);
        }
        return null;
    }

    private boolean isFolder(String fullpathValue) {
        return fullpathValue.endsWith("/");
    }

    static {
        DomUtils.registerNamespace((DSSNamespace)ManifestNamespace.NS);
    }
}

