/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.signature.asice;

import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.asic.xades.signature.GetDataToSignASiCWithXAdESHelper;
import eu.europa.esig.dss.asic.xades.signature.asice.AbstractDataToSignASiCEWithXAdES;
import eu.europa.esig.dss.model.DSSDocument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DataToSignASiCEWithXAdESFromFiles
extends AbstractDataToSignASiCEWithXAdES
implements GetDataToSignASiCWithXAdESHelper {
    private final List<DSSDocument> filesToBeSigned;
    private final ASiCParameters asicParameters;

    public DataToSignASiCEWithXAdESFromFiles(List<DSSDocument> filesToBeSigned, ASiCParameters asicParameters) {
        this.filesToBeSigned = filesToBeSigned;
        this.asicParameters = asicParameters;
    }

    @Override
    public List<DSSDocument> getToBeSigned() {
        return this.filesToBeSigned;
    }

    public String getSignatureFilename() {
        return this.getSignatureFileName(this.asicParameters, Collections.emptyList());
    }

    public String getTimestampFilename() {
        throw new UnsupportedOperationException("Timestamp file cannot be added with ASiC-E + XAdES");
    }

    public List<DSSDocument> getSignedDocuments() {
        return this.filesToBeSigned;
    }

    @Override
    public DSSDocument getExistingSignature() {
        return null;
    }

    public List<DSSDocument> getManifestFiles() {
        return Arrays.asList(this.getASiCManifest(this.filesToBeSigned));
    }

    public List<DSSDocument> getSignatures() {
        return new ArrayList<DSSDocument>();
    }

    @Override
    public DSSDocument getRootDocument() {
        return null;
    }
}

