/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.signature.asice;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.asic.xades.definition.ManifestAttribute;
import eu.europa.esig.dss.asic.xades.definition.ManifestElement;
import eu.europa.esig.dss.asic.xades.definition.ManifestNamespace;
import eu.europa.esig.dss.definition.DSSAttribute;
import eu.europa.esig.dss.definition.DSSElement;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.MimeType;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ASiCEWithXAdESManifestBuilder {
    private final List<DSSDocument> documents;

    public ASiCEWithXAdESManifestBuilder(List<DSSDocument> documents) {
        this.documents = documents;
    }

    public Document build() {
        Document documentDom = DomUtils.buildDOM();
        Element manifestDom = DomUtils.createElementNS((Document)documentDom, (DSSNamespace)ManifestNamespace.NS, (DSSElement)ManifestElement.MANIFEST);
        DomUtils.setAttributeNS((Element)manifestDom, (DSSNamespace)ManifestNamespace.NS, (DSSAttribute)ManifestAttribute.VERSION, (String)"1.2");
        documentDom.appendChild(manifestDom);
        Element rootDom = DomUtils.addElement((Document)documentDom, (Element)manifestDom, (DSSNamespace)ManifestNamespace.NS, (DSSElement)ManifestElement.FILE_ENTRY);
        DomUtils.setAttributeNS((Element)rootDom, (DSSNamespace)ManifestNamespace.NS, (DSSAttribute)ManifestAttribute.FULL_PATH, (String)"/");
        DomUtils.setAttributeNS((Element)rootDom, (DSSNamespace)ManifestNamespace.NS, (DSSAttribute)ManifestAttribute.MEDIA_TYPE, (String)MimeType.ASICE.getMimeTypeString());
        for (DSSDocument document : this.documents) {
            Element fileDom = DomUtils.addElement((Document)documentDom, (Element)manifestDom, (DSSNamespace)ManifestNamespace.NS, (DSSElement)ManifestElement.FILE_ENTRY);
            DomUtils.setAttributeNS((Element)fileDom, (DSSNamespace)ManifestNamespace.NS, (DSSAttribute)ManifestAttribute.FULL_PATH, (String)document.getName());
            MimeType mimeType = document.getMimeType();
            if (mimeType == null) continue;
            DomUtils.setAttributeNS((Element)fileDom, (DSSNamespace)ManifestNamespace.NS, (DSSAttribute)ManifestAttribute.MEDIA_TYPE, (String)mimeType.getMimeTypeString());
        }
        return documentDom;
    }
}

