/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.definition.ASiCElement;
import eu.europa.esig.dss.asic.common.definition.ASiCNamespace;
import eu.europa.esig.dss.asic.common.signature.AbstractASiCSignatureService;
import eu.europa.esig.dss.asic.xades.ASiCWithXAdESContainerExtractor;
import eu.europa.esig.dss.asic.xades.ASiCWithXAdESSignatureParameters;
import eu.europa.esig.dss.asic.xades.OpenDocumentSupportUtils;
import eu.europa.esig.dss.asic.xades.definition.ManifestNamespace;
import eu.europa.esig.dss.asic.xades.signature.ASiCWithXAdESCounterSignatureHelper;
import eu.europa.esig.dss.asic.xades.signature.ASiCWithXAdESDataToSignHelperBuilder;
import eu.europa.esig.dss.asic.xades.signature.GetDataToSignASiCWithXAdESHelper;
import eu.europa.esig.dss.definition.DSSElement;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.SerializableCounterSignatureParameters;
import eu.europa.esig.dss.model.SerializableSignatureParameters;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.XAdESTimestampParameters;
import eu.europa.esig.dss.xades.signature.XAdESCounterSignatureParameters;
import eu.europa.esig.dss.xades.signature.XAdESService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ASiCWithXAdESService
extends AbstractASiCSignatureService<ASiCWithXAdESSignatureParameters, XAdESTimestampParameters, XAdESCounterSignatureParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCWithXAdESService.class);

    public ASiCWithXAdESService(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
        LOG.debug("+ ASiCService with XAdES created");
    }

    public TimestampToken getContentTimestamp(List<DSSDocument> toSignDocuments, ASiCWithXAdESSignatureParameters parameters) {
        GetDataToSignASiCWithXAdESHelper getDataToSignHelper = new ASiCWithXAdESDataToSignHelperBuilder().build(toSignDocuments, parameters);
        XAdESSignatureParameters xadesParameters = this.getParameters(parameters, getDataToSignHelper);
        return this.getXAdESService().getContentTimestamp(getDataToSignHelper.getSignedDocuments(), xadesParameters);
    }

    public ToBeSigned getDataToSign(List<DSSDocument> toSignDocuments, ASiCWithXAdESSignatureParameters parameters) {
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        if (Utils.isCollectionEmpty(toSignDocuments)) {
            throw new DSSException("List of documents to sign cannot be empty!");
        }
        GetDataToSignASiCWithXAdESHelper dataToSignHelper = new ASiCWithXAdESDataToSignHelperBuilder().build(toSignDocuments, parameters);
        XAdESSignatureParameters xadesParameters = this.getParameters(parameters, dataToSignHelper);
        return this.getXAdESService().getDataToSign(dataToSignHelper.getSignedDocuments(), xadesParameters);
    }

    public DSSDocument signDocument(List<DSSDocument> toSignDocuments, ASiCWithXAdESSignatureParameters parameters, SignatureValue signatureValue) {
        Objects.requireNonNull(toSignDocuments, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        Objects.requireNonNull(signatureValue, "SignatureValue cannot be null!");
        if (Utils.isCollectionEmpty(toSignDocuments)) {
            throw new DSSException("List of documents to sign cannot be empty!");
        }
        ASiCParameters asicParameters = parameters.aSiC();
        this.assertSigningDateInCertificateValidityRange((SerializableSignatureParameters)parameters);
        GetDataToSignASiCWithXAdESHelper dataToSignHelper = new ASiCWithXAdESDataToSignHelperBuilder().build(toSignDocuments, parameters);
        List signatures = dataToSignHelper.getSignatures();
        List manifestFiles = dataToSignHelper.getManifestFiles();
        List signedDocuments = dataToSignHelper.getSignedDocuments();
        DSSDocument rootContainer = dataToSignHelper.getRootDocument();
        XAdESSignatureParameters xadesParameters = this.getParameters(parameters, dataToSignHelper);
        DSSDocument newSignature = this.getXAdESService().signDocument(signedDocuments, xadesParameters, signatureValue);
        String newSignatureFilename = dataToSignHelper.getSignatureFilename();
        newSignature.setName(newSignatureFilename);
        if (ASiCUtils.isASiCS((ASiCParameters)asicParameters) || rootContainer != null) {
            Iterator iterator = signatures.iterator();
            while (iterator.hasNext()) {
                if (!Utils.areStringsEqual((String)newSignatureFilename, (String)((DSSDocument)iterator.next()).getName())) continue;
                iterator.remove();
            }
        }
        signatures.add(newSignature);
        DSSDocument asicSignature = rootContainer != null ? this.mergeArchiveAndExtendedSignatures(rootContainer, signatures, parameters.bLevel().getSigningDate(), ASiCUtils.getZipComment((ASiCParameters)asicParameters)) : this.buildASiCContainer(signedDocuments, signatures, manifestFiles, asicParameters, parameters.bLevel().getSigningDate());
        asicSignature.setName(this.getFinalDocumentName(asicSignature, SigningOperation.SIGN, parameters.getSignatureLevel(), asicSignature.getMimeType()));
        parameters.reinitDeterministicId();
        return asicSignature;
    }

    public DSSDocument timestamp(List<DSSDocument> toTimestampDocuments, XAdESTimestampParameters parameters) {
        throw new UnsupportedOperationException("Timestamp file cannot be added with ASiC-S/E + XAdES");
    }

    public DSSDocument extendDocument(DSSDocument toExtendDocument, ASiCWithXAdESSignatureParameters parameters) {
        Objects.requireNonNull(toExtendDocument, "toExtendDocument is not defined!");
        Objects.requireNonNull(parameters, "Cannot extend the signature. SignatureParameters are not defined!");
        this.assertExtensionSupported(toExtendDocument);
        this.extractCurrentArchive(toExtendDocument);
        List signatureDocuments = this.getEmbeddedSignatures();
        this.assertValidSignaturesToExtendFound(signatureDocuments);
        ArrayList<DSSDocument> extendedDocuments = new ArrayList<DSSDocument>();
        boolean openDocument = ASiCUtils.isOpenDocument((DSSDocument)this.getEmbeddedMimetype());
        for (DSSDocument signature : signatureDocuments) {
            XAdESSignatureParameters xadesParameters = this.getXAdESParameters(parameters, null, openDocument);
            if (openDocument) {
                xadesParameters.setDetachedContents(OpenDocumentSupportUtils.getOpenDocumentCoverage(this.archiveContent));
            } else {
                xadesParameters.setDetachedContents(this.getEmbeddedSignedDocuments());
            }
            DSSDocument extendDocument = this.getXAdESService().extendDocument(signature, xadesParameters);
            extendDocument.setName(signature.getName());
            extendedDocuments.add(extendDocument);
        }
        DSSDocument extensionResult = this.mergeArchiveAndExtendedSignatures(toExtendDocument, extendedDocuments, parameters.bLevel().getSigningDate(), ASiCUtils.getZipComment((ASiCParameters)parameters.aSiC()));
        extensionResult.setName(this.getFinalDocumentName(toExtendDocument, SigningOperation.EXTEND, parameters.getSignatureLevel(), toExtendDocument.getMimeType()));
        return extensionResult;
    }

    private void assertExtensionSupported(DSSDocument toExtendDocument) {
        if (!ASiCUtils.isZip((DSSDocument)toExtendDocument)) {
            throw new DSSException("Unsupported file type");
        }
    }

    private void assertValidSignaturesToExtendFound(List<DSSDocument> signatureDocuments) {
        if (Utils.isCollectionEmpty(signatureDocuments)) {
            throw new DSSException("No supported signature documents found! Unable to extend the container.");
        }
    }

    private XAdESService getXAdESService() {
        XAdESService xadesService = new XAdESService(this.certificateVerifier);
        xadesService.setTspSource(this.tspSource);
        return xadesService;
    }

    private XAdESSignatureParameters getParameters(ASiCWithXAdESSignatureParameters parameters, GetDataToSignASiCWithXAdESHelper dataToSignHelper) {
        boolean openDocument = dataToSignHelper.getRootDocument() != null;
        return this.getXAdESParameters(parameters, dataToSignHelper.getExistingSignature(), openDocument);
    }

    private XAdESSignatureParameters getXAdESParameters(ASiCWithXAdESSignatureParameters parameters, DSSDocument existingXAdESSignature, boolean openDocument) {
        ASiCWithXAdESSignatureParameters xadesParameters = parameters;
        xadesParameters.setSignaturePackaging(SignaturePackaging.DETACHED);
        Document rootDocument = null;
        rootDocument = existingXAdESSignature != null ? DomUtils.buildDOM((DSSDocument)existingXAdESSignature) : this.buildDomRoot(openDocument);
        xadesParameters.setRootDocument(rootDocument);
        return xadesParameters;
    }

    private Document buildDomRoot(boolean openDocument) {
        Document rootDocument = DomUtils.buildDOM();
        Element xadesSignatures = null;
        xadesSignatures = openDocument ? rootDocument.createElementNS("urn:oasis:names:tc:opendocument:xmlns:digitalsignature:1.0", "document-signatures") : DomUtils.createElementNS((Document)rootDocument, (DSSNamespace)ASiCNamespace.NS, (DSSElement)ASiCElement.XADES_SIGNATURES);
        rootDocument.appendChild(xadesSignatures);
        return rootDocument;
    }

    protected AbstractASiCContainerExtractor getArchiveExtractor(DSSDocument archive) {
        return new ASiCWithXAdESContainerExtractor(archive);
    }

    protected String getExpectedSignatureExtension() {
        return ".xml";
    }

    public DSSDocument addSignaturePolicyStore(DSSDocument asicContainer, SignaturePolicyStore signaturePolicyStore) {
        Objects.requireNonNull(asicContainer, "The asicContainer cannot be null");
        Objects.requireNonNull(signaturePolicyStore, "The signaturePolicyStore cannot be null");
        this.extractCurrentArchive(asicContainer);
        this.assertAddSignaturePolicyStorePossible();
        XAdESService xadesService = this.getXAdESService();
        ArrayList<DSSDocument> extendedSignatures = new ArrayList<DSSDocument>();
        for (DSSDocument signature : this.getEmbeddedSignatures()) {
            DSSDocument signatureWithPolicyStore = xadesService.addSignaturePolicyStore(signature, signaturePolicyStore);
            signatureWithPolicyStore.setName(signature.getName());
            extendedSignatures.add(signatureWithPolicyStore);
        }
        DSSDocument resultArchive = this.mergeArchiveAndExtendedSignatures(asicContainer, extendedSignatures, null, ASiCUtils.getZipComment((String)asicContainer.getMimeType().getMimeTypeString()));
        resultArchive.setName(this.getFinalArchiveName(asicContainer, SigningOperation.ADD_SIG_POLICY_STORE, asicContainer.getMimeType()));
        return resultArchive;
    }

    public ToBeSigned getDataToBeCounterSigned(DSSDocument asicContainer, XAdESCounterSignatureParameters parameters) {
        Objects.requireNonNull(asicContainer, "asicContainer cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        this.assertCounterSignatureParametersValid((SerializableCounterSignatureParameters)parameters);
        ASiCWithXAdESCounterSignatureHelper counterSignatureHelper = new ASiCWithXAdESCounterSignatureHelper(asicContainer);
        DSSDocument signatureDocument = counterSignatureHelper.extractSignatureDocument(parameters.getSignatureIdToCounterSign());
        XAdESService xadesService = this.getXAdESService();
        return xadesService.getDataToBeCounterSigned(signatureDocument, parameters);
    }

    public DSSDocument counterSignSignature(DSSDocument asicContainer, XAdESCounterSignatureParameters parameters, SignatureValue signatureValue) {
        Objects.requireNonNull(asicContainer, "asicContainer cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        Objects.requireNonNull(signatureValue, "signatureValue cannot be null!");
        this.assertCounterSignatureParametersValid((SerializableCounterSignatureParameters)parameters);
        ASiCWithXAdESCounterSignatureHelper counterSignatureHelper = new ASiCWithXAdESCounterSignatureHelper(asicContainer);
        DSSDocument signatureDocument = counterSignatureHelper.extractSignatureDocument(parameters.getSignatureIdToCounterSign());
        XAdESService xadesService = this.getXAdESService();
        DSSDocument counterSignedSignature = xadesService.counterSignSignature(signatureDocument, parameters, signatureValue);
        counterSignedSignature.setName(signatureDocument.getName());
        List newSignaturesList = counterSignatureHelper.getUpdatedSignatureDocumentsList(counterSignedSignature);
        DSSDocument resultArchive = this.mergeArchiveAndExtendedSignatures(asicContainer, newSignaturesList, parameters.bLevel().getSigningDate(), ASiCUtils.getZipComment((String)asicContainer.getMimeType().getMimeTypeString()));
        resultArchive.setName(this.getFinalDocumentName(asicContainer, SigningOperation.COUNTER_SIGN, parameters.getSignatureLevel(), asicContainer.getMimeType()));
        return resultArchive;
    }

    static {
        DomUtils.registerNamespace((DSSNamespace)ASiCNamespace.NS);
        DomUtils.registerNamespace((DSSNamespace)ManifestNamespace.NS);
    }
}

