/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.signature;

import eu.europa.esig.dss.asic.common.ASiCExtractResult;
import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.signature.AbstractASiCDataToSignHelperBuilder;
import eu.europa.esig.dss.asic.xades.ASiCWithXAdESContainerExtractor;
import eu.europa.esig.dss.asic.xades.ASiCWithXAdESSignatureParameters;
import eu.europa.esig.dss.asic.xades.signature.GetDataToSignASiCWithXAdESHelper;
import eu.europa.esig.dss.asic.xades.signature.asice.DataToSignASiCEWithXAdESFromArchive;
import eu.europa.esig.dss.asic.xades.signature.asice.DataToSignASiCEWithXAdESFromFiles;
import eu.europa.esig.dss.asic.xades.signature.asice.DataToSignOpenDocument;
import eu.europa.esig.dss.asic.xades.signature.asics.DataToSignASiCSWithXAdESFromArchive;
import eu.europa.esig.dss.asic.xades.signature.asics.DataToSignASiCSWithXAdESFromFiles;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ASiCWithXAdESDataToSignHelperBuilder
extends AbstractASiCDataToSignHelperBuilder {
    public GetDataToSignASiCWithXAdESHelper build(List<DSSDocument> documents, ASiCWithXAdESSignatureParameters parameters) {
        DSSDocument archiveDocument;
        if (Utils.isCollectionNotEmpty(documents) && documents.size() == 1 && ASiCUtils.isZip((DSSDocument)(archiveDocument = documents.get(0)))) {
            return this.fromZipArchive(archiveDocument, parameters);
        }
        return this.fromFiles(documents, parameters);
    }

    private GetDataToSignASiCWithXAdESHelper fromZipArchive(DSSDocument archiveDocument, ASiCWithXAdESSignatureParameters parameters) {
        boolean asice = ASiCUtils.isASiCE((ASiCParameters)parameters.aSiC());
        ASiCWithXAdESContainerExtractor extractor = new ASiCWithXAdESContainerExtractor(archiveDocument);
        ASiCExtractResult extract = extractor.extract();
        ASiCWithXAdESDataToSignHelperBuilder.assertContainerTypeValid(extract);
        if (ASiCUtils.isOpenDocument((DSSDocument)extract.getMimeTypeDocument())) {
            return new DataToSignOpenDocument(extract.getSignedDocuments(), extract.getSignatureDocuments(), extract.getManifestDocuments(), extract.getMimeTypeDocument(), extract.getRootContainer());
        }
        if (Utils.isCollectionNotEmpty((Collection)extract.getSignatureDocuments())) {
            ASiCContainerType currentContainerType = ASiCUtils.getContainerType((DSSDocument)archiveDocument, (DSSDocument)extract.getMimeTypeDocument(), (String)extract.getZipComment(), (List)extract.getSignedDocuments());
            if (asice && ASiCContainerType.ASiC_E.equals((Object)currentContainerType)) {
                return new DataToSignASiCEWithXAdESFromArchive(extract.getSignedDocuments(), extract.getSignatureDocuments(), extract.getManifestDocuments(), parameters.aSiC());
            }
            if (!asice && ASiCContainerType.ASiC_S.equals((Object)currentContainerType)) {
                return new DataToSignASiCSWithXAdESFromArchive(extract.getSignatureDocuments(), extract.getSignedDocuments(), parameters.aSiC());
            }
            throw new UnsupportedOperationException(String.format("Original container type '%s' vs parameter : '%s'", currentContainerType, parameters.aSiC().getContainerType()));
        }
        return this.fromFiles(Arrays.asList(archiveDocument), parameters);
    }

    private GetDataToSignASiCWithXAdESHelper fromFiles(List<DSSDocument> documents, ASiCWithXAdESSignatureParameters parameters) {
        this.assertDocumentNamesDefined(documents);
        if (ASiCUtils.isASiCE((ASiCParameters)parameters.aSiC())) {
            return new DataToSignASiCEWithXAdESFromFiles(documents, parameters.aSiC());
        }
        return new DataToSignASiCSWithXAdESFromFiles(documents, parameters.bLevel().getSigningDate(), parameters.aSiC());
    }

    private static void assertContainerTypeValid(ASiCExtractResult result) {
        if (ASiCUtils.areFilesContainSignatures((List)DSSUtils.getDocumentNames((List)result.getAllDocuments())) && Utils.isCollectionEmpty((Collection)result.getSignatureDocuments())) {
            throw new UnsupportedOperationException("Container type doesn't match");
        }
    }
}

