/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.signature.asice;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.xades.definition.ManifestAttribute;
import eu.europa.esig.dss.asic.xades.definition.ManifestElement;
import eu.europa.esig.dss.asic.xades.definition.ManifestNamespace;
import eu.europa.esig.dss.definition.DSSAttribute;
import eu.europa.esig.dss.definition.DSSElement;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.ManifestEntry;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ASiCEWithXAdESManifestBuilder {
    private List<DSSDocument> documents;
    private List<ManifestEntry> entries;
    private String manifestFilename;

    public ASiCEWithXAdESManifestBuilder() {
    }

    @Deprecated
    public ASiCEWithXAdESManifestBuilder(List<DSSDocument> documents) {
        this.documents = documents;
    }

    public ASiCEWithXAdESManifestBuilder setDocuments(List<DSSDocument> documents) {
        this.documents = documents;
        return this;
    }

    public ASiCEWithXAdESManifestBuilder setEntries(List<ManifestEntry> entries) {
        this.entries = entries;
        return this;
    }

    public ASiCEWithXAdESManifestBuilder setManifestFilename(String manifestFilename) {
        this.manifestFilename = manifestFilename;
        return this;
    }

    public DSSDocument build() {
        Document documentDom = DomUtils.buildDOM();
        Element manifestDom = DomUtils.createElementNS((Document)documentDom, (DSSNamespace)ManifestNamespace.NS, (DSSElement)ManifestElement.MANIFEST);
        DomUtils.setAttributeNS((Element)manifestDom, (DSSNamespace)ManifestNamespace.NS, (DSSAttribute)ManifestAttribute.VERSION, (String)"1.2");
        documentDom.appendChild(manifestDom);
        Element rootDom = DomUtils.addElement((Document)documentDom, (Element)manifestDom, (DSSNamespace)ManifestNamespace.NS, (DSSElement)ManifestElement.FILE_ENTRY);
        DomUtils.setAttributeNS((Element)rootDom, (DSSNamespace)ManifestNamespace.NS, (DSSAttribute)ManifestAttribute.FULL_PATH, (String)"/");
        DomUtils.setAttributeNS((Element)rootDom, (DSSNamespace)ManifestNamespace.NS, (DSSAttribute)ManifestAttribute.MEDIA_TYPE, (String)MimeType.ASICE.getMimeTypeString());
        for (ManifestEntry entry : this.getEntries()) {
            Element fileDom = DomUtils.addElement((Document)documentDom, (Element)manifestDom, (DSSNamespace)ManifestNamespace.NS, (DSSElement)ManifestElement.FILE_ENTRY);
            DomUtils.setAttributeNS((Element)fileDom, (DSSNamespace)ManifestNamespace.NS, (DSSAttribute)ManifestAttribute.FULL_PATH, (String)entry.getFileName());
            MimeType mimeType = entry.getMimeType();
            if (mimeType == null) continue;
            DomUtils.setAttributeNS((Element)fileDom, (DSSNamespace)ManifestNamespace.NS, (DSSAttribute)ManifestAttribute.MEDIA_TYPE, (String)mimeType.getMimeTypeString());
        }
        return DomUtils.createDssDocumentFromDomDocument((Document)documentDom, (String)this.manifestFilename);
    }

    private List<ManifestEntry> getEntries() {
        if (Utils.isCollectionNotEmpty(this.documents) && Utils.isCollectionNotEmpty(this.entries)) {
            throw new IllegalArgumentException("Either DSSDocuments or ManifestEntries shall be provided!");
        }
        if (Utils.isCollectionNotEmpty(this.documents)) {
            return ASiCUtils.toSimpleManifestEntries(this.documents);
        }
        if (Utils.isCollectionNotEmpty(this.entries)) {
            return this.entries;
        }
        throw new NullPointerException("Either DSSDocuments or ManifestEntries shall be provided!");
    }
}

