/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades.signature;

import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.xades.signature.DefaultASiCWithXAdESFilenameFactory;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;

public class SimpleASiCWithXAdESFilenameFactory
extends DefaultASiCWithXAdESFilenameFactory {
    private String signatureFilename;
    private String manifestFilename;
    private String dataPackageFilename;

    @Override
    public String getSignatureFilename(ASiCContent asicContent) {
        if (Utils.isStringNotEmpty((String)this.signatureFilename)) {
            return this.getValidSignatureFilename(this.signatureFilename, asicContent);
        }
        return super.getSignatureFilename(asicContent);
    }

    public void setSignatureFilename(String signatureFilename) {
        this.signatureFilename = signatureFilename;
    }

    @Override
    public String getManifestFilename(ASiCContent asicContent) {
        if (Utils.isStringNotEmpty((String)this.manifestFilename)) {
            return this.getValidManifestFilename(this.manifestFilename, asicContent);
        }
        return super.getManifestFilename(asicContent);
    }

    public void setManifestFilename(String manifestFilename) {
        this.manifestFilename = manifestFilename;
    }

    @Override
    public String getDataPackageFilename(ASiCContent asicContent) {
        if (Utils.isStringNotEmpty((String)this.dataPackageFilename)) {
            return this.getValidDataPackageFilename(this.dataPackageFilename, asicContent);
        }
        return super.getDataPackageFilename(asicContent);
    }

    public void setDataPackageFilename(String dataPackageFilename) {
        this.dataPackageFilename = dataPackageFilename;
    }

    protected String getValidSignatureFilename(String signatureFilename, ASiCContent asicContent) {
        signatureFilename = this.getWithMetaInfFolder(signatureFilename);
        this.assertFilenameValid(signatureFilename, asicContent.getSignatureDocuments());
        if (ASiCUtils.isASiCSContainer((ASiCContent)asicContent) && !"META-INF/signatures.xml".equals(signatureFilename)) {
            throw new IllegalArgumentException(String.format("A signature file within ASiC-S with XAdES container shall have name '%s'!", "META-INF/signatures.xml"));
        }
        if (ASiCUtils.isOpenDocument((DSSDocument)asicContent.getMimeTypeDocument()) && !"META-INF/documentsignatures.xml".equals(signatureFilename)) {
            throw new IllegalArgumentException(String.format("A signature file within OpenDocument container shall have name '%s'!", "META-INF/documentsignatures.xml"));
        }
        if (!signatureFilename.startsWith("META-INF/signatures") || !signatureFilename.endsWith(".xml")) {
            throw new IllegalArgumentException(String.format("A signature file within ASiC-E with XAdES container shall match the template '%s'!", "META-INF/signatures*.xml"));
        }
        return signatureFilename;
    }

    protected String getValidManifestFilename(String manifestFilename, ASiCContent asicContent) {
        manifestFilename = this.getWithMetaInfFolder(manifestFilename);
        this.assertFilenameValid(manifestFilename, asicContent.getManifestDocuments());
        if (!"META-INF/manifest.xml".equals(manifestFilename)) {
            throw new IllegalArgumentException(String.format("A manifest file within ASiC with XAdES container shall have name '%s'!", "META-INF/manifest.xml"));
        }
        return manifestFilename;
    }
}

