/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.validation;

import eu.europa.esig.asic.manifest.definition.ASiCManifestAttribute;
import eu.europa.esig.asic.manifest.definition.ASiCManifestNamespace;
import eu.europa.esig.asic.manifest.definition.ASiCManifestPath;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.enumerations.ASiCManifestTypeEnum;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.MimeType;
import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.ManifestEntry;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xml.common.definition.DSSNamespace;
import eu.europa.esig.dss.xml.utils.DomUtils;
import eu.europa.esig.xmldsig.definition.XMLDSigNamespace;
import eu.europa.esig.xmldsig.definition.XMLDSigPath;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ASiCManifestParser {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCManifestParser.class);

    private ASiCManifestParser() {
    }

    public static ManifestFile getManifestFile(DSSDocument manifestDocument) {
        Element root = ASiCManifestParser.getManifestRootElement(manifestDocument);
        if (root == null) {
            return null;
        }
        ManifestFile manifest = new ManifestFile();
        manifest.setDocument(manifestDocument);
        manifest.setSignatureFilename(ASiCManifestParser.getLinkedSignatureName(root));
        manifest.setEntries(ASiCManifestParser.parseManifestEntries(root));
        manifest.setManifestType(ASiCManifestParser.getManifestType(manifestDocument.getName(), root));
        return manifest;
    }

    public static DSSDocument getLinkedManifest(List<DSSDocument> manifestDocuments, String signatureName) {
        for (DSSDocument manifest : manifestDocuments) {
            String linkedSignatureName;
            Element manifestRoot = ASiCManifestParser.getManifestRootElement(manifest);
            if (manifestRoot == null || !signatureName.equals(linkedSignatureName = DSSUtils.decodeURI((String)ASiCManifestParser.getLinkedSignatureName(manifestRoot)))) continue;
            return manifest;
        }
        return null;
    }

    private static Element getManifestRootElement(DSSDocument manifestDocument) {
        if (!DomUtils.isDOM((DSSDocument)manifestDocument)) {
            LOG.warn("Unable to analyze manifest file '{}' : Not a valid XML file!", (Object)manifestDocument.getName());
            return null;
        }
        try {
            Document manifestDom = DomUtils.buildDOM((DSSDocument)manifestDocument);
            return DomUtils.getElement((Node)manifestDom, (String)ASiCManifestPath.ASIC_MANIFEST_PATH);
        }
        catch (Exception e) {
            LOG.warn("Unable to analyze manifest file '{}' : {}", (Object)manifestDocument.getName(), (Object)e.getMessage());
            return null;
        }
    }

    private static String getLinkedSignatureName(Element root) {
        return DomUtils.getValue((Node)root, (String)ASiCManifestPath.SIG_REFERENCE_URI_PATH);
    }

    private static MimeType getMimeType(Element element) {
        try {
            String mimeTypeString = element.getAttribute(ASiCManifestAttribute.MIME_TYPE.getAttributeName());
            if (Utils.isStringNotBlank((String)mimeTypeString)) {
                return MimeType.fromMimeTypeString((String)mimeTypeString);
            }
        }
        catch (DSSException e) {
            LOG.warn("Cannot extract MimeType for a reference. Reason : [{}]", (Object)e.getMessage());
        }
        return null;
    }

    private static DigestAlgorithm getDigestAlgorithm(Element dataObjectReference) {
        String value = null;
        try {
            value = DomUtils.getValue((Node)dataObjectReference, (String)XMLDSigPath.DIGEST_METHOD_ALGORITHM_PATH);
            return DigestAlgorithm.forXML((String)value);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Unable to extract DigestAlgorithm (value = {}). Reason : [{}]", (Object)value, (Object)e.getMessage());
            return null;
        }
    }

    private static byte[] getDigestValue(Element dataObjectReference) {
        try {
            Element digestValueElement = DomUtils.getElement((Node)dataObjectReference, (String)XMLDSigPath.DIGEST_VALUE_PATH);
            if (digestValueElement != null) {
                String digest = digestValueElement.getTextContent();
                if (Utils.isBase64Encoded((String)digest)) {
                    return Utils.fromBase64((String)digestValueElement.getTextContent());
                }
                LOG.warn("The manifest entry digest value is not base64-encoded!");
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to extract DigestValue. Reason : [{}]", (Object)e.getMessage());
        }
        return null;
    }

    private static ASiCManifestTypeEnum getManifestType(String manifestFilename, Element root) {
        Element sigReference;
        if (ASiCUtils.isArchiveManifest(manifestFilename)) {
            return ASiCManifestTypeEnum.ARCHIVE_MANIFEST;
        }
        if (ASiCUtils.isEvidenceRecordManifest(manifestFilename)) {
            return ASiCManifestTypeEnum.EVIDENCE_RECORD;
        }
        if (ASiCUtils.isManifest(manifestFilename) && (sigReference = DomUtils.getElement((Node)root, (String)ASiCManifestPath.SIG_REFERENCE_PATH)) != null) {
            MimeType mimeType = ASiCManifestParser.getMimeType(sigReference);
            return MimeTypeEnum.TST == mimeType ? ASiCManifestTypeEnum.TIMESTAMP : ASiCManifestTypeEnum.SIGNATURE;
        }
        return null;
    }

    private static List<ManifestEntry> parseManifestEntries(Element root) {
        ArrayList<ManifestEntry> entries = new ArrayList<ManifestEntry>();
        NodeList dataObjectReferences = DomUtils.getNodeList((Node)root, (String)ASiCManifestPath.DATA_OBJECT_REFERENCE_PATH);
        if (dataObjectReferences == null || dataObjectReferences.getLength() == 0) {
            LOG.warn("No DataObjectReference found in manifest file");
        } else {
            for (int i = 0; i < dataObjectReferences.getLength(); ++i) {
                String attribute;
                ManifestEntry entry = new ManifestEntry();
                Element dataObjectReference = (Element)dataObjectReferences.item(i);
                entry.setFileName(DSSUtils.decodeURI((String)dataObjectReference.getAttribute(ASiCManifestAttribute.URI.getAttributeName())));
                entry.setMimeType(ASiCManifestParser.getMimeType(dataObjectReference));
                DigestAlgorithm digestAlgorithm = ASiCManifestParser.getDigestAlgorithm(dataObjectReference);
                byte[] digestValueBinary = ASiCManifestParser.getDigestValue(dataObjectReference);
                if (digestAlgorithm != null && digestValueBinary != null) {
                    entry.setDigest(new Digest(digestAlgorithm, digestValueBinary));
                }
                if (Utils.areStringsEqualIgnoreCase((String)"true", (String)(attribute = dataObjectReference.getAttribute(ASiCManifestAttribute.ROOTFILE.getAttributeName())))) {
                    entry.setRootfile(true);
                }
                entries.add(entry);
            }
        }
        return entries;
    }

    static {
        DomUtils.registerNamespace((DSSNamespace)XMLDSigNamespace.NS);
        DomUtils.registerNamespace((DSSNamespace)ASiCManifestNamespace.NS);
    }
}

