/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.validation;

import eu.europa.esig.dss.asic.common.ASiCExtractResult;
import eu.europa.esig.dss.asic.common.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.validation.ASiCContainerDiagnosticDataBuilder;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.ContainerInfo;
import eu.europa.esig.dss.validation.DiagnosticDataBuilder;
import eu.europa.esig.dss.validation.DocumentValidator;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.scope.SignatureScopeFinder;
import eu.europa.esig.dss.validation.timestamp.DetachedTimestampValidator;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractASiCContainerValidator
extends SignedDocumentValidator {
    protected List<DocumentValidator> signatureValidators;
    protected List<DetachedTimestampValidator> timestampValidators;
    protected ASiCExtractResult extractResult;
    private List<ManifestFile> manifestFiles;

    protected AbstractASiCContainerValidator(DSSDocument document) {
        this(document, null);
    }

    protected AbstractASiCContainerValidator(DSSDocument document, SignatureScopeFinder signatureScopeFinder) {
        super(signatureScopeFinder);
        this.document = document;
    }

    protected void extractEntries() {
        AbstractASiCContainerExtractor extractor = this.getContainerExtractor();
        this.extractResult = extractor.extract();
    }

    protected abstract AbstractASiCContainerExtractor getContainerExtractor();

    protected DiagnosticDataBuilder createDiagnosticDataBuilder(ValidationContext validationContext, List<AdvancedSignature> signatures) {
        ASiCContainerDiagnosticDataBuilder builder = (ASiCContainerDiagnosticDataBuilder)super.createDiagnosticDataBuilder(validationContext, signatures);
        builder.containerInfo(this.getContainerInfo());
        return builder;
    }

    protected ASiCContainerDiagnosticDataBuilder initializeDiagnosticDataBuilder() {
        return new ASiCContainerDiagnosticDataBuilder();
    }

    protected ContainerInfo getContainerInfo() {
        List<DSSDocument> originalSignedDocuments;
        ContainerInfo containerInfo = new ContainerInfo();
        containerInfo.setContainerType(this.extractResult.getContainerType());
        containerInfo.setZipComment(this.extractResult.getZipComment());
        DSSDocument mimeTypeDocument = this.extractResult.getMimeTypeDocument();
        if (mimeTypeDocument != null) {
            String mimeTypeContent = new String(DSSUtils.toByteArray((DSSDocument)mimeTypeDocument));
            containerInfo.setMimeTypeContent(mimeTypeContent);
        }
        if (Utils.isCollectionNotEmpty(originalSignedDocuments = this.extractResult.getSignedDocuments())) {
            ArrayList<String> signedDocumentFilenames = new ArrayList<String>();
            for (DSSDocument dssDocument : originalSignedDocuments) {
                signedDocumentFilenames.add(dssDocument.getName());
            }
            containerInfo.setSignedDocumentFilenames(signedDocumentFilenames);
        }
        containerInfo.setManifestFiles(this.getManifestFiles());
        return containerInfo;
    }

    protected List<TimestampToken> attachExternalTimestamps(List<AdvancedSignature> allSignatures) {
        return Collections.emptyList();
    }

    protected abstract List<ManifestFile> getManifestFilesDescriptions();

    public List<AdvancedSignature> getAllSignatures() {
        this.setSignedScopeFinderDefaultDigestAlgorithm(this.certificateVerifier.getDefaultDigestAlgorithm());
        ArrayList<AdvancedSignature> allSignatureList = new ArrayList<AdvancedSignature>();
        List<DocumentValidator> currentValidators = this.getSignatureValidators();
        for (DocumentValidator signatureValidator : currentValidators) {
            List signatures = signatureValidator.getSignatures();
            for (AdvancedSignature advancedSignature : signatures) {
                allSignatureList.add(advancedSignature);
                this.appendCounterSignatures(allSignatureList, advancedSignature);
            }
        }
        this.findSignatureScopes(allSignatureList);
        this.attachExternalTimestamps(allSignatureList);
        return allSignatureList;
    }

    public List<AdvancedSignature> getSignatures() {
        ArrayList<AdvancedSignature> signatureList = new ArrayList<AdvancedSignature>();
        for (DocumentValidator validator : this.getSignatureValidators()) {
            signatureList.addAll(validator.getSignatures());
        }
        return signatureList;
    }

    protected abstract List<DocumentValidator> getSignatureValidators();

    public ASiCContainerType getContainerType() {
        return this.extractResult.getContainerType();
    }

    public List<DSSDocument> getAllDocuments() {
        return this.extractResult.getAllDocuments();
    }

    public List<DSSDocument> getSignatureDocuments() {
        return this.extractResult.getSignatureDocuments();
    }

    public List<DSSDocument> getSignedDocuments() {
        return this.extractResult.getSignedDocuments();
    }

    public List<DSSDocument> getManifestDocuments() {
        return this.extractResult.getManifestDocuments();
    }

    public List<DSSDocument> getTimestampDocuments() {
        return this.extractResult.getTimestampDocuments();
    }

    public List<DSSDocument> getArchiveManifestDocuments() {
        return this.extractResult.getArchiveManifestDocuments();
    }

    public List<DSSDocument> getAllManifestDocuments() {
        return this.extractResult.getAllManifestDocuments();
    }

    public List<DSSDocument> getArchiveDocuments() {
        return this.extractResult.getContainerDocuments();
    }

    public DSSDocument getMimeTypeDocument() {
        return this.extractResult.getMimeTypeDocument();
    }

    public List<DSSDocument> getUnsupportedDocuments() {
        return this.extractResult.getUnsupportedDocuments();
    }

    public List<ManifestFile> getManifestFiles() {
        if (this.manifestFiles == null) {
            this.manifestFiles = this.getManifestFilesDescriptions();
        }
        return this.manifestFiles;
    }

    protected List<DSSDocument> getSignedDocumentsASiCS(List<DSSDocument> retrievedDocs) {
        List<DSSDocument> containerDocuments = this.extractResult.getContainerDocuments();
        if (Utils.isCollectionNotEmpty(containerDocuments)) {
            return containerDocuments;
        }
        return retrievedDocs;
    }
}

