/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.signature;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractASiCDataToSignHelperBuilder {
    private static final String ZIP_ENTRY_DETACHED_FILE = "detached-file";

    protected void assertDocumentNamesDefined(List<DSSDocument> documents) {
        List<DSSDocument> unnamedDocuments = this.getDocumentsWithoutNames(documents);
        if (unnamedDocuments.size() == 1) {
            DSSDocument dssDocument = unnamedDocuments.iterator().next();
            dssDocument.setName(ZIP_ENTRY_DETACHED_FILE);
        } else {
            for (int ii = 0; ii < unnamedDocuments.size(); ++ii) {
                DSSDocument dssDocument = unnamedDocuments.get(ii);
                dssDocument.setName("detached-file-" + ii);
            }
        }
    }

    private List<DSSDocument> getDocumentsWithoutNames(List<DSSDocument> documents) {
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        for (DSSDocument document : documents) {
            if (!Utils.isStringBlank((String)document.getName())) continue;
            result.add(document);
        }
        return result;
    }
}

