/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.signature;

import eu.europa.esig.dss.asic.common.ASiCExtractResult;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.DocumentValidator;
import eu.europa.esig.dss.validation.ManifestFile;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ASiCCounterSignatureHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCCounterSignatureHelper.class);
    protected final DSSDocument asicContainer;
    private ASiCExtractResult extractResult;

    protected ASiCCounterSignatureHelper(DSSDocument asicContainer) {
        this.asicContainer = asicContainer;
    }

    public DSSDocument extractSignatureDocument(String signatureId) {
        if (!ASiCUtils.isZip(this.asicContainer)) {
            throw new DSSException("The provided file shall be an ASiC container with signatures inside!");
        }
        List<DSSDocument> signatureDocuments = this.getSignatureDocuments();
        if (Utils.isCollectionEmpty(signatureDocuments)) {
            throw new DSSException("No signatures found to be extended!");
        }
        for (DSSDocument signatureDocument : signatureDocuments) {
            if (!this.containsSignatureToBeCounterSigned(signatureDocument, signatureId)) continue;
            this.checkCounterSignaturePossible(signatureDocument);
            return signatureDocument;
        }
        throw new DSSException(String.format("A signature with id '%s' has not been found!", signatureId));
    }

    public List<DSSDocument> getSignatureDocuments() {
        ASiCExtractResult extractResult = this.getASiCExtractResult();
        return extractResult.getSignatureDocuments();
    }

    protected abstract List<DSSDocument> getDetachedDocuments(String var1);

    public ManifestFile getManifestFile(String signatureFilename) {
        return null;
    }

    protected ASiCExtractResult getASiCExtractResult() {
        if (this.extractResult == null) {
            AbstractASiCContainerExtractor extractor = this.getASiCContainerExtractor();
            this.extractResult = extractor.extract();
        }
        return this.extractResult;
    }

    protected abstract AbstractASiCContainerExtractor getASiCContainerExtractor();

    protected abstract DocumentValidator getDocumentValidator(DSSDocument var1);

    private boolean containsSignatureToBeCounterSigned(DSSDocument signatureDocument, String signatureId) {
        try {
            DocumentValidator validator = this.getDocumentValidator(signatureDocument);
            validator.setDetachedContents(this.getDetachedDocuments(signatureDocument.getName()));
            validator.setManifestFile(this.getManifestFile(signatureDocument.getName()));
            List signatures = validator.getSignatures();
            for (AdvancedSignature signature : signatures) {
                if (!this.containsSignatureToBeCounterSigned(signature, signatureId)) continue;
                return true;
            }
        }
        catch (Exception e) {
            String errorMessage = "Unable to verify a file with name '{}'. Reason : {}";
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, new Object[]{signatureDocument.getName(), e.getMessage(), e});
            }
            LOG.warn(errorMessage, (Object)signatureDocument.getName(), (Object)e.getMessage());
        }
        return false;
    }

    private boolean containsSignatureToBeCounterSigned(AdvancedSignature signature, String signatureId) {
        if (signatureId.equals(signature.getId()) || signatureId.equals(signature.getDAIdentifier())) {
            return true;
        }
        for (AdvancedSignature counterSignature : signature.getCounterSignatures()) {
            if (!this.containsSignatureToBeCounterSigned(counterSignature, signatureId)) continue;
            return true;
        }
        return false;
    }

    protected void checkCounterSignaturePossible(DSSDocument signatureDocument) {
    }

    public List<DSSDocument> getUpdatedSignatureDocumentsList(DSSDocument updatedSignatureDocument) {
        ArrayList<DSSDocument> newSignaturesList = new ArrayList<DSSDocument>();
        for (DSSDocument signature : this.getSignatureDocuments()) {
            if (updatedSignatureDocument.getName().equals(signature.getName())) {
                newSignaturesList.add(updatedSignatureDocument);
                continue;
            }
            newSignaturesList.add(signature);
        }
        return newSignaturesList;
    }
}

