/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common;

import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.ZipContainerHandler;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureContainerHandler
implements ZipContainerHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SecureContainerHandler.class);
    private long threshold = 1000000L;
    private long maxCompressionRatio = 100L;
    private int maxAllowedFilesAmount = 1000;
    private int maxMalformedFiles = 100;
    private int byteCounter = 0;

    public void setThreshold(long threshold) {
        this.threshold = threshold;
    }

    public void setMaxCompressionRatio(long maxCompressionRatio) {
        this.maxCompressionRatio = maxCompressionRatio;
    }

    public void setMaxAllowedFilesAmount(int maxAllowedFilesAmount) {
        this.maxAllowedFilesAmount = maxAllowedFilesAmount;
    }

    public void setMaxMalformedFiles(int maxMalformedFiles) {
        this.maxMalformedFiles = maxMalformedFiles;
    }

    @Override
    public List<DSSDocument> extractContainerContent(DSSDocument zipArchive) {
        this.resetByteCounter();
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        long containerSize = DSSUtils.getFileByteSize((DSSDocument)zipArchive);
        try (InputStream is = zipArchive.openStream();
             ZipInputStream zis = new ZipInputStream(is);){
            DSSDocument document;
            while ((document = this.getNextDocument(zis, containerSize)) != null) {
                result.add(document);
                this.assertCollectionSizeValid(result);
            }
        }
        catch (IOException e) {
            throw new DSSException("Unable to extract package.zip", (Throwable)e);
        }
        return result;
    }

    private DSSDocument getNextDocument(ZipInputStream zis, long containerSize) {
        ZipEntry entry = this.getNextValidEntry(zis);
        if (entry != null) {
            DSSDocument currentDocument = this.getCurrentDocument(zis, containerSize);
            currentDocument.setName(entry.getName());
            return currentDocument;
        }
        return null;
    }

    @Override
    public List<String> extractEntryNames(DSSDocument zipArchive) {
        this.resetByteCounter();
        long containerSize = DSSUtils.getFileByteSize((DSSDocument)zipArchive);
        long allowedSize = containerSize * this.maxCompressionRatio;
        ArrayList<String> result = new ArrayList<String>();
        try (InputStream is = zipArchive.openStream();
             ZipInputStream zis = new ZipInputStream(is);){
            ZipEntry entry;
            while ((entry = this.getNextValidEntry(zis)) != null) {
                result.add(entry.getName());
                this.assertCollectionSizeValid(result);
                this.secureRead(zis, allowedSize);
            }
        }
        catch (IOException e) {
            throw new DSSException("Unable to extract package.zip", (Throwable)e);
        }
        return result;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public DSSDocument createZipArchive(List<DSSDocument> containerEntries, Date creationTime, String zipComment) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            InMemoryDocument inMemoryDocument;
            try (ZipOutputStream zos = new ZipOutputStream(baos);){
                for (DSSDocument entry : containerEntries) {
                    ZipEntry zipEntry = this.getZipEntry(entry, creationTime);
                    zos.putNextEntry(zipEntry);
                    InputStream entryIS = entry.openStream();
                    try {
                        this.secureCopy(entryIS, zos, -1L);
                    }
                    finally {
                        if (entryIS == null) continue;
                        entryIS.close();
                    }
                }
                if (Utils.isStringNotEmpty((String)zipComment)) {
                    zos.setComment(zipComment);
                }
                zos.finish();
                inMemoryDocument = new InMemoryDocument(baos.toByteArray());
            }
            return inMemoryDocument;
        }
        catch (IOException e) {
            throw new DSSException(String.format("Unable to create an ASiC container. Reason : %s", e.getMessage()), (Throwable)e);
        }
    }

    private ZipEntry getZipEntry(DSSDocument entry, Date creationTime) {
        String name = entry.getName();
        ZipEntry zipEntry = new ZipEntry(name);
        if (ASiCUtils.isMimetype(name)) {
            zipEntry.setMethod(0);
            byte[] byteArray = DSSUtils.toByteArray((DSSDocument)entry);
            zipEntry.setSize(byteArray.length);
            zipEntry.setCompressedSize(byteArray.length);
            CRC32 crc = new CRC32();
            crc.update(byteArray);
            zipEntry.setCrc(crc.getValue());
        } else {
            zipEntry.setMethod(8);
        }
        if (creationTime != null) {
            zipEntry.setTime(creationTime.getTime());
        }
        return zipEntry;
    }

    private void resetByteCounter() {
        this.byteCounter = 0;
    }

    private ZipEntry getNextValidEntry(ZipInputStream zis) {
        for (int counter = 0; counter < this.maxMalformedFiles; ++counter) {
            try {
                return zis.getNextEntry();
            }
            catch (Exception e) {
                LOG.warn("ZIP container contains a malformed, corrupted or not accessible entry! The entry is skipped. Reason: [{}]", (Object)e.getMessage());
                this.closeEntry(zis);
                continue;
            }
        }
        throw new DSSException("Unable to retrieve a valid ZipEntry (" + this.maxMalformedFiles + " tries)");
    }

    private void closeEntry(ZipInputStream zis) {
        try {
            zis.closeEntry();
        }
        catch (IOException e) {
            throw new DSSException("Unable to close entry", (Throwable)e);
        }
    }

    private DSSDocument getCurrentDocument(ZipInputStream zis, long containerSize) {
        InMemoryDocument inMemoryDocument;
        long allowedSize = containerSize * this.maxCompressionRatio;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.secureCopy(zis, baos, allowedSize);
            baos.flush();
            inMemoryDocument = new InMemoryDocument(baos.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.closeEntry(zis);
                throw new DSSException(String.format("Unable to read an entry binaries. Reason : %s", e.getMessage()), (Throwable)e);
            }
        }
        baos.close();
        return inMemoryDocument;
    }

    private void secureCopy(InputStream is, OutputStream os, long allowedSize) throws IOException {
        int nRead;
        byte[] data = new byte[2048];
        while ((nRead = is.read(data)) != -1) {
            this.byteCounter += nRead;
            this.assertExtractEntryLengthValid(allowedSize);
            os.write(data, 0, nRead);
        }
    }

    private void secureRead(InputStream is, long allowedSize) throws IOException {
        int nRead;
        byte[] data = new byte[2048];
        while ((nRead = is.read(data)) != -1) {
            this.byteCounter += nRead;
            this.assertExtractEntryLengthValid(allowedSize);
        }
    }

    private void assertExtractEntryLengthValid(long allowedSize) {
        if (allowedSize != -1L && (long)this.byteCounter > this.threshold && (long)this.byteCounter > allowedSize) {
            throw new DSSException("Zip Bomb detected in the ZIP container. Validation is interrupted.");
        }
    }

    private void assertCollectionSizeValid(Collection<?> collection) {
        if (collection.size() > this.maxAllowedFilesAmount) {
            throw new DSSException("Too many files detected. Cannot extract ASiC content from the file.");
        }
    }
}

