/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.validation.scope;

import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.scope.CAdESSignatureScopeFinder;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.ManifestEntry;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.scope.ContainerContentSignatureScope;
import eu.europa.esig.dss.validation.scope.ContainerSignatureScope;
import eu.europa.esig.dss.validation.scope.FullSignatureScope;
import eu.europa.esig.dss.validation.scope.ManifestSignatureScope;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import java.util.ArrayList;
import java.util.List;

public class ASiCWithCAdESSignatureScopeFinder
extends CAdESSignatureScopeFinder {
    public List<SignatureScope> findSignatureScope(CAdESSignature cadesSignature) {
        ArrayList<SignatureScope> result = new ArrayList<SignatureScope>();
        DSSDocument originalDocument = this.getOriginalDocument(cadesSignature);
        if (originalDocument == null) {
            return result;
        }
        if (this.isASiCSArchive((AdvancedSignature)cadesSignature, originalDocument)) {
            ContainerSignatureScope containerSignatureScope = new ContainerSignatureScope(originalDocument.getName(), DSSUtils.getDigest((DigestAlgorithm)this.getDefaultDigestAlgorithm(), (DSSDocument)originalDocument));
            result.add((SignatureScope)containerSignatureScope);
            for (DSSDocument archivedDocument : cadesSignature.getContainerContents()) {
                containerSignatureScope.addChildSignatureScope((SignatureScope)new ContainerContentSignatureScope(DSSUtils.decodeURI((String)archivedDocument.getName()), this.getDigest(archivedDocument)));
            }
        } else if (this.isASiCEArchive((AdvancedSignature)cadesSignature)) {
            ManifestFile manifestFile = cadesSignature.getManifestFile();
            ManifestSignatureScope manifestSignatureScope = new ManifestSignatureScope(manifestFile.getFilename(), new Digest(this.getDefaultDigestAlgorithm(), Utils.fromBase64((String)manifestFile.getDigestBase64String(this.getDefaultDigestAlgorithm()))));
            result.add((SignatureScope)manifestSignatureScope);
            for (ManifestEntry manifestEntry : manifestFile.getEntries()) {
                if (!manifestEntry.isIntact()) continue;
                manifestSignatureScope.addChildSignatureScope((SignatureScope)new FullSignatureScope(manifestEntry.getFileName(), manifestEntry.getDigest()));
            }
        } else {
            return this.getSignatureScopeFromOriginalDocument(cadesSignature, originalDocument);
        }
        return result;
    }
}

