/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.validation;

import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.ManifestEntry;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.scope.ContainerContentSignatureScope;
import eu.europa.esig.dss.validation.scope.ContainerSignatureScope;
import eu.europa.esig.dss.validation.scope.ManifestSignatureScope;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import eu.europa.esig.dss.validation.timestamp.DetachedTimestampValidator;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.ArrayList;
import java.util.List;

public class ASiCWithCAdESTimestampValidator
extends DetachedTimestampValidator {
    private List<DSSDocument> originalDocuments;
    private List<DSSDocument> archiveDocuments;

    public ASiCWithCAdESTimestampValidator(DSSDocument timestamp) {
        super(timestamp);
    }

    public ASiCWithCAdESTimestampValidator(DSSDocument timestamp, TimestampType type) {
        super(timestamp, type);
    }

    public ManifestFile getCoveredManifest() {
        return this.manifestFile;
    }

    public void setOriginalDocuments(List<DSSDocument> originalDocuments) {
        this.originalDocuments = originalDocuments;
    }

    public void setArchiveDocuments(List<DSSDocument> archiveDocuments) {
        this.archiveDocuments = archiveDocuments;
    }

    public TimestampToken getTimestamp() {
        TimestampToken timestamp = super.getTimestamp();
        if (this.manifestFile != null) {
            timestamp.setManifestFile(this.manifestFile);
        }
        if (TimestampType.ARCHIVE_TIMESTAMP.equals((Object)this.timestampType)) {
            timestamp.setArchiveTimestampType(ArchiveTimestampType.CAdES_DETACHED);
        }
        timestamp.setTimestampScopes(this.getTimestampSignatureScopes());
        return timestamp;
    }

    protected List<SignatureScope> getTimestampSignatureScopes() {
        if (this.manifestFile != null) {
            return this.getTimestampSignatureScopeForManifest();
        }
        return this.getTimestampSignatureScopeForDocument(this.getTimestampedData());
    }

    private List<SignatureScope> getTimestampSignatureScopeForManifest() {
        ArrayList<SignatureScope> result = new ArrayList<SignatureScope>();
        result.add((SignatureScope)new ManifestSignatureScope(this.manifestFile.getFilename(), this.getDigest(this.getTimestampedData())));
        if (Utils.isCollectionNotEmpty(this.originalDocuments)) {
            for (ManifestEntry manifestEntry : this.manifestFile.getEntries()) {
                for (DSSDocument document : this.originalDocuments) {
                    if (!Utils.areStringsEqual((String)manifestEntry.getFileName(), (String)document.getName())) continue;
                    result.addAll(this.getTimestampSignatureScopeForDocument(document));
                }
            }
        }
        return result;
    }

    protected List<SignatureScope> getTimestampSignatureScopeForDocument(DSSDocument document) {
        if (ASiCUtils.isASiCSArchive((DSSDocument)document)) {
            return this.getTimestampSignatureScopeForZipPackage(document);
        }
        return super.getTimestampSignatureScopeForDocument(document);
    }

    private List<SignatureScope> getTimestampSignatureScopeForZipPackage(DSSDocument document) {
        ArrayList<SignatureScope> result = new ArrayList<SignatureScope>();
        result.add((SignatureScope)new ContainerSignatureScope(document.getName(), this.getDigest(document)));
        if (Utils.isCollectionNotEmpty(this.archiveDocuments)) {
            for (DSSDocument archivedDocument : this.archiveDocuments) {
                result.add((SignatureScope)new ContainerContentSignatureScope(DSSUtils.decodeURI((String)archivedDocument.getName()), this.getDigest(archivedDocument)));
            }
        }
        return result;
    }

    protected boolean addReference(SignatureScope signatureScope) {
        String fileName = signatureScope.getName();
        return fileName == null || !ASiCUtils.isSignature((String)fileName) && !ASiCUtils.isTimestamp((String)fileName);
    }
}

