/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.validation;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESContainerExtractor;
import eu.europa.esig.dss.asic.cades.validation.ASiCEWithCAdESManifestValidator;
import eu.europa.esig.dss.asic.cades.validation.ASiCWithCAdESDiagnosticDataBuilder;
import eu.europa.esig.dss.asic.cades.validation.ASiCWithCAdESExtractResultUtils;
import eu.europa.esig.dss.asic.cades.validation.ASiCWithCAdESManifestParser;
import eu.europa.esig.dss.asic.cades.validation.ASiCWithCAdESTimestampValidator;
import eu.europa.esig.dss.asic.cades.validation.scope.ASiCWithCAdESSignatureScopeFinder;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.ZipUtils;
import eu.europa.esig.dss.asic.common.validation.AbstractASiCContainerValidator;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CMSDocumentValidator;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.DocumentValidator;
import eu.europa.esig.dss.validation.ManifestEntry;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.scope.SignatureScopeFinder;
import eu.europa.esig.dss.validation.timestamp.DetachedTimestampSource;
import eu.europa.esig.dss.validation.timestamp.DetachedTimestampValidator;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampValidator;
import eu.europa.esig.dss.validation.timestamp.TimestampValidatorComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASiCContainerWithCAdESValidator
extends AbstractASiCContainerValidator {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCContainerWithCAdESValidator.class);

    ASiCContainerWithCAdESValidator() {
        super(null);
    }

    public ASiCContainerWithCAdESValidator(DSSDocument asicContainer) {
        super(asicContainer, (SignatureScopeFinder)new ASiCWithCAdESSignatureScopeFinder());
        this.extractEntries();
    }

    public boolean isSupported(DSSDocument dssDocument) {
        if (ASiCUtils.isZip((DSSDocument)dssDocument)) {
            List filenames = ZipUtils.getInstance().extractEntryNames(dssDocument);
            if (ASiCUtils.isASiCWithCAdES((List)filenames)) {
                return true;
            }
            return !ASiCUtils.isASiCWithXAdES((List)filenames) && (!ASiCUtils.areFilesContainMimetype((List)filenames) || !ASiCUtils.isContainerOpenDocument((DSSDocument)dssDocument));
        }
        return false;
    }

    protected AbstractASiCContainerExtractor getContainerExtractor() {
        return new ASiCWithCAdESContainerExtractor(this.document);
    }

    protected List<DocumentValidator> getSignatureValidators() {
        if (this.signatureValidators == null) {
            this.signatureValidators = new ArrayList();
            for (DSSDocument signature : this.getSignatureDocuments()) {
                DSSDocument signatureManifest;
                CMSDocumentValidator cadesValidator = new CMSDocumentValidator(signature);
                cadesValidator.setCertificateVerifier(this.certificateVerifier);
                cadesValidator.setProcessExecutor(this.processExecutor);
                cadesValidator.setSignaturePolicyProvider(this.getSignaturePolicyProvider());
                cadesValidator.setContainerContents(this.getArchiveDocuments());
                DSSDocument signedDocument = ASiCWithCAdESExtractResultUtils.getSignedDocument(this.extractResult, signature.getName());
                if (signedDocument != null) {
                    cadesValidator.setDetachedContents(Collections.singletonList(signedDocument));
                }
                if ((signatureManifest = ASiCWithCAdESManifestParser.getLinkedManifest(this.getAllManifestDocuments(), signature.getName())) != null) {
                    ManifestFile manifestFile = this.toValidatedManifestFile(signatureManifest);
                    cadesValidator.setManifestFile(manifestFile);
                }
                this.signatureValidators.add(cadesValidator);
            }
        }
        return this.signatureValidators;
    }

    protected List<DetachedTimestampValidator> getTimestampValidators() {
        if (this.timestampValidators == null) {
            this.timestampValidators = new ArrayList();
            for (DSSDocument timestamp : this.getTimestampDocuments()) {
                DSSDocument timestampedDocument;
                TimestampType timestampType = TimestampType.CONTENT_TIMESTAMP;
                ManifestFile manifestFile = null;
                DSSDocument archiveManifest = ASiCWithCAdESManifestParser.getLinkedManifest(this.getAllManifestDocuments(), timestamp.getName());
                if (archiveManifest != null) {
                    timestampedDocument = archiveManifest;
                    manifestFile = this.toValidatedManifestFile(archiveManifest);
                    if (manifestFile != null) {
                        timestampType = this.getTimestampType(manifestFile);
                    } else {
                        LOG.warn("A linked manifest is not found for a timestamp with name [{}]!", (Object)archiveManifest.getName());
                    }
                } else if (Utils.collectionSize((Collection)this.getSignedDocuments()) == 1) {
                    timestampedDocument = (DSSDocument)this.getSignedDocuments().get(0);
                } else {
                    LOG.warn("Timestamp {} is skipped (no linked archive manifest found / unique file)", (Object)timestamp.getName());
                    continue;
                }
                ASiCWithCAdESTimestampValidator timestampValidator = new ASiCWithCAdESTimestampValidator(timestamp, timestampType);
                timestampValidator.setTimestampedData(timestampedDocument);
                timestampValidator.setManifestFile(manifestFile);
                timestampValidator.setOriginalDocuments(this.getAllDocuments());
                timestampValidator.setArchiveDocuments(this.getArchiveDocuments());
                timestampValidator.setCertificateVerifier(this.certificateVerifier);
                this.timestampValidators.add(timestampValidator);
            }
            this.timestampValidators.sort(new TimestampValidatorComparator());
        }
        return this.timestampValidators;
    }

    public List<TimestampToken> getDetachedTimestamps() {
        DetachedTimestampSource detachedTimestampSource = new DetachedTimestampSource();
        for (DetachedTimestampValidator timestampValidator : this.getTimestampValidators()) {
            detachedTimestampSource.addExternalTimestamp(timestampValidator.getTimestamp());
        }
        return detachedTimestampSource.getDetachedTimestamps();
    }

    public List<DSSDocument> getArchiveDocuments() {
        List archiveContents = super.getArchiveDocuments();
        if (Utils.isCollectionNotEmpty((Collection)this.getManifestDocuments())) {
            for (DSSDocument document : this.getAllDocuments()) {
                if (archiveContents.contains(document)) continue;
                archiveContents.add(document);
            }
        }
        return archiveContents;
    }

    protected List<TimestampToken> attachExternalTimestamps(List<AdvancedSignature> allSignatures) {
        ArrayList<TimestampToken> externalTimestamps = new ArrayList<TimestampToken>();
        List<DetachedTimestampValidator> currentTimestampValidators = this.getTimestampValidators();
        for (DetachedTimestampValidator tspValidator : currentTimestampValidators) {
            TimestampToken timestamp = this.getExternalTimestamp((TimestampValidator)tspValidator, allSignatures);
            if (timestamp == null) continue;
            externalTimestamps.add(timestamp);
        }
        return externalTimestamps;
    }

    private TimestampToken getExternalTimestamp(TimestampValidator tspValidator, List<AdvancedSignature> allSignatures) {
        if (tspValidator instanceof ASiCWithCAdESTimestampValidator) {
            ManifestFile coveredManifest;
            ASiCWithCAdESTimestampValidator timestampValidator = (ASiCWithCAdESTimestampValidator)tspValidator;
            TimestampToken timestamp = timestampValidator.getTimestamp();
            if (TimestampType.ARCHIVE_TIMESTAMP.equals((Object)timestamp.getTimeStampType()) && (coveredManifest = timestampValidator.getCoveredManifest()) != null) {
                for (ManifestEntry entry : coveredManifest.getEntries()) {
                    for (AdvancedSignature advancedSignature : allSignatures) {
                        if (!Utils.areStringsEqual((String)entry.getFileName(), (String)advancedSignature.getSignatureFilename()) || advancedSignature.isCounterSignature()) continue;
                        CAdESSignature cadesSig = (CAdESSignature)advancedSignature;
                        cadesSig.addExternalTimestamp(timestamp);
                    }
                }
            }
            return timestamp;
        }
        return null;
    }

    private ManifestFile toValidatedManifestFile(DSSDocument manifest) {
        List manifestFiles = this.getManifestFiles();
        if (Utils.isCollectionNotEmpty((Collection)manifestFiles)) {
            for (ManifestFile manifestFile : manifestFiles) {
                if (!Utils.areStringsEqual((String)manifest.getName(), (String)manifestFile.getFilename())) continue;
                return manifestFile;
            }
        }
        return null;
    }

    private TimestampType getTimestampType(ManifestFile manifestFile) {
        return ASiCUtils.coversSignature((ManifestFile)manifestFile) ? TimestampType.ARCHIVE_TIMESTAMP : TimestampType.CONTENT_TIMESTAMP;
    }

    protected List<ManifestFile> getManifestFilesDescriptions() {
        ArrayList<ManifestFile> descriptions = new ArrayList<ManifestFile>();
        List manifestDocuments = this.getManifestDocuments();
        for (DSSDocument manifestDocument : manifestDocuments) {
            ManifestFile manifestFile = ASiCWithCAdESManifestParser.getManifestFile(manifestDocument);
            if (manifestFile == null) continue;
            ASiCEWithCAdESManifestValidator asiceWithCAdESManifestValidator = new ASiCEWithCAdESManifestValidator(manifestFile, this.getAllDocuments());
            asiceWithCAdESManifestValidator.validateEntries();
            descriptions.add(manifestFile);
        }
        List archiveManifestDocuments = this.getArchiveManifestDocuments();
        for (DSSDocument manifestDocument : archiveManifestDocuments) {
            ManifestFile manifestFile = ASiCWithCAdESManifestParser.getManifestFile(manifestDocument);
            if (manifestFile == null) continue;
            manifestFile.setArchiveManifest(true);
            ASiCEWithCAdESManifestValidator asiceWithCAdESManifestValidator = new ASiCEWithCAdESManifestValidator(manifestFile, this.getAllDocuments());
            asiceWithCAdESManifestValidator.validateEntries();
            descriptions.add(manifestFile);
        }
        return descriptions;
    }

    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        if (advancedSignature.isCounterSignature()) {
            CAdESSignature cadesSignature = (CAdESSignature)advancedSignature;
            return Arrays.asList(cadesSignature.getOriginalDocument());
        }
        List retrievedDocs = advancedSignature.getDetachedContents();
        if (ASiCContainerType.ASiC_S.equals((Object)this.getContainerType())) {
            return this.getSignedDocumentsASiCS(retrievedDocs);
        }
        DSSDocument linkedManifest = ASiCWithCAdESManifestParser.getLinkedManifest(this.getManifestDocuments(), advancedSignature.getSignatureFilename());
        if (linkedManifest == null) {
            return Collections.emptyList();
        }
        ManifestFile manifestFile = ASiCWithCAdESManifestParser.getManifestFile(linkedManifest);
        return this.getManifestedDocuments(manifestFile);
    }

    private List<DSSDocument> getManifestedDocuments(ManifestFile manifestFile) {
        List entries = manifestFile.getEntries();
        List signedDocuments = this.getAllDocuments();
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        for (ManifestEntry entry : entries) {
            for (DSSDocument signedDocument : signedDocuments) {
                if (!Utils.areStringsEqual((String)entry.getFileName(), (String)signedDocument.getName())) continue;
                result.add(signedDocument);
            }
        }
        return result;
    }

    protected ASiCWithCAdESDiagnosticDataBuilder initializeDiagnosticDataBuilder() {
        return new ASiCWithCAdESDiagnosticDataBuilder();
    }
}

