/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature.manifest;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.asic.cades.signature.manifest.AbstractManifestBuilder;
import eu.europa.esig.dss.asic.common.definition.ASiCAttribute;
import eu.europa.esig.dss.asic.common.definition.ASiCElement;
import eu.europa.esig.dss.asic.common.definition.ASiCNamespace;
import eu.europa.esig.dss.definition.DSSElement;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.MimeType;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ASiCEWithCAdESArchiveManifestBuilder
extends AbstractManifestBuilder {
    private final List<DSSDocument> signatures;
    private final List<DSSDocument> timestamps;
    private final List<DSSDocument> signedFiles;
    private final List<DSSDocument> manifests;
    private final DSSDocument lastArchiveManifest;
    private final DigestAlgorithm digestAlgorithm;
    private final String timestampFileUri;

    public ASiCEWithCAdESArchiveManifestBuilder(List<DSSDocument> signatures, List<DSSDocument> timestamps, List<DSSDocument> signedFiles, List<DSSDocument> manifests, DSSDocument lastArchiveManifest, DigestAlgorithm digestAlgorithm, String timestampFileUri) {
        this.signatures = signatures;
        this.timestamps = timestamps;
        this.signedFiles = signedFiles;
        this.manifests = manifests;
        this.lastArchiveManifest = lastArchiveManifest;
        this.digestAlgorithm = digestAlgorithm;
        this.timestampFileUri = timestampFileUri;
    }

    public Document build() {
        Document documentDom = DomUtils.buildDOM();
        Element asicManifestDom = DomUtils.createElementNS((Document)documentDom, (DSSNamespace)ASiCNamespace.NS, (DSSElement)ASiCElement.ASIC_MANIFEST);
        documentDom.appendChild(asicManifestDom);
        this.addSigReference(documentDom, asicManifestDom, this.timestampFileUri, MimeType.TST);
        for (DSSDocument signature : this.signatures) {
            this.addDataObjectReference(documentDom, asicManifestDom, signature, this.digestAlgorithm);
        }
        for (DSSDocument timestamp : this.timestamps) {
            this.addDataObjectReference(documentDom, asicManifestDom, timestamp, this.digestAlgorithm);
        }
        for (DSSDocument manifest : this.manifests) {
            this.addDataObjectReference(documentDom, asicManifestDom, manifest, this.digestAlgorithm);
        }
        if (this.lastArchiveManifest != null) {
            this.addDataObjectReferenceForRootArchiveManifest(documentDom, asicManifestDom, this.lastArchiveManifest, this.digestAlgorithm);
        }
        for (DSSDocument document : this.signedFiles) {
            this.addDataObjectReference(documentDom, asicManifestDom, document, this.digestAlgorithm);
        }
        return documentDom;
    }

    private Element addDataObjectReferenceForRootArchiveManifest(Document documentDom, Element asicManifestDom, DSSDocument document, DigestAlgorithm digestAlgorithm) {
        Element dataObjectReferenceElement = this.addDataObjectReference(documentDom, asicManifestDom, document, digestAlgorithm);
        dataObjectReferenceElement.setAttribute(ASiCAttribute.ROOTFILE.getAttributeName(), "true");
        return dataObjectReferenceElement;
    }
}

