/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature.asics;

import eu.europa.esig.dss.asic.cades.signature.GetDataToSignASiCWithCAdESHelper;
import eu.europa.esig.dss.asic.cades.signature.asics.AbstractGetDataToSignASiCSWithCAdES;
import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class DataToSignASiCSWithCAdESFromFiles
extends AbstractGetDataToSignASiCSWithCAdES
implements GetDataToSignASiCWithCAdESHelper {
    private final List<DSSDocument> filesToBeSigned;
    private final Date signingDate;
    private List<DSSDocument> signedDocuments;

    public DataToSignASiCSWithCAdESFromFiles(List<DSSDocument> filesToBeSigned, Date signingDate, ASiCParameters asicParameters) {
        super(asicParameters);
        this.filesToBeSigned = filesToBeSigned;
        this.signingDate = signingDate;
    }

    @Override
    public DSSDocument getAsicContainer() {
        return null;
    }

    public String getSignatureFilename() {
        return this.getSignatureFileName();
    }

    public String getTimestampFilename() {
        return this.getTimestampFileName();
    }

    @Override
    public DSSDocument getToBeSigned() {
        return this.getSignedDocuments().get(0);
    }

    @Override
    public List<DSSDocument> getDetachedContents() {
        return Collections.emptyList();
    }

    public List<DSSDocument> getSignedDocuments() {
        if (this.signedDocuments == null) {
            if (Utils.collectionSize(this.filesToBeSigned) > 1) {
                DSSDocument packageZip = this.createPackageZip(this.filesToBeSigned, this.signingDate, ASiCUtils.getZipComment((ASiCParameters)this.asicParameters));
                this.signedDocuments = Arrays.asList(packageZip);
            } else {
                this.signedDocuments = new ArrayList<DSSDocument>(this.filesToBeSigned);
            }
        }
        return this.signedDocuments;
    }

    public List<DSSDocument> getManifestFiles() {
        return Collections.emptyList();
    }

    public List<DSSDocument> getSignatures() {
        return new ArrayList<DSSDocument>();
    }

    @Override
    public List<DSSDocument> getArchiveManifestFiles() {
        return Collections.emptyList();
    }

    @Override
    public List<DSSDocument> getTimestamps() {
        return new ArrayList<DSSDocument>();
    }
}

