/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature.asice;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESCommonParameters;
import eu.europa.esig.dss.asic.cades.signature.GetDataToSignASiCWithCAdESHelper;
import eu.europa.esig.dss.asic.cades.signature.asice.AbstractDataToSignASiCEWithCAdES;
import eu.europa.esig.dss.asic.common.ASiCExtractResult;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.signature.SigningOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataToSignASiCEWithCAdESFromArchive
extends AbstractDataToSignASiCEWithCAdES
implements GetDataToSignASiCWithCAdESHelper {
    private final DSSDocument asicContainer;
    private final List<DSSDocument> signedDocuments;
    private final List<DSSDocument> embeddedSignatures;
    private final List<DSSDocument> embeddedManifests;
    private final List<DSSDocument> embeddedArchiveManifests;
    private final List<DSSDocument> embeddedTimestamps;
    private DSSDocument toBeSigned;

    public DataToSignASiCEWithCAdESFromArchive(SigningOperation operation, ASiCExtractResult extractionResult, ASiCWithCAdESCommonParameters parameters) {
        super(operation, parameters);
        this.asicContainer = extractionResult.getAsicContainer();
        this.signedDocuments = extractionResult.getSignedDocuments();
        this.embeddedSignatures = extractionResult.getSignatureDocuments();
        this.embeddedManifests = extractionResult.getManifestDocuments();
        this.embeddedArchiveManifests = extractionResult.getArchiveManifestDocuments();
        this.embeddedTimestamps = extractionResult.getTimestampDocuments();
    }

    @Override
    public DSSDocument getAsicContainer() {
        return this.asicContainer;
    }

    public String getSignatureFilename() {
        return this.getSignatureFileName(this.embeddedSignatures);
    }

    public String getTimestampFilename() {
        return this.getTimestampFileName(this.embeddedTimestamps);
    }

    @Override
    public DSSDocument getToBeSigned() {
        if (this.toBeSigned == null) {
            this.toBeSigned = this.getASiCManifest(this.signedDocuments, this.embeddedSignatures, this.embeddedTimestamps, this.embeddedManifests);
        }
        return this.toBeSigned;
    }

    @Override
    public List<DSSDocument> getDetachedContents() {
        return Collections.emptyList();
    }

    public List<DSSDocument> getSignedDocuments() {
        return this.signedDocuments;
    }

    public List<DSSDocument> getManifestFiles() {
        ArrayList<DSSDocument> manifests = new ArrayList<DSSDocument>(this.embeddedManifests);
        manifests.add(this.getToBeSigned());
        return manifests;
    }

    public List<DSSDocument> getSignatures() {
        return this.embeddedSignatures;
    }

    @Override
    public List<DSSDocument> getArchiveManifestFiles() {
        return this.embeddedArchiveManifests;
    }

    @Override
    public List<DSSDocument> getTimestamps() {
        return this.embeddedTimestamps;
    }
}

