/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESContainerExtractor;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESSignatureParameters;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESTimestampParameters;
import eu.europa.esig.dss.asic.cades.signature.ASiCWithCAdESCounterSignatureHelper;
import eu.europa.esig.dss.asic.cades.signature.ASiCWithCAdESDataToSignHelperBuilder;
import eu.europa.esig.dss.asic.cades.signature.GetDataToSignASiCWithCAdESHelper;
import eu.europa.esig.dss.asic.cades.signature.manifest.ASiCEWithCAdESArchiveManifestBuilder;
import eu.europa.esig.dss.asic.cades.validation.ASiCContainerWithCAdESValidator;
import eu.europa.esig.dss.asic.cades.validation.ASiCWithCAdESExtractResultUtils;
import eu.europa.esig.dss.asic.cades.validation.ASiCWithCAdESManifestParser;
import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.signature.AbstractASiCSignatureService;
import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.signature.CAdESCounterSignatureBuilder;
import eu.europa.esig.dss.cades.signature.CAdESCounterSignatureParameters;
import eu.europa.esig.dss.cades.signature.CAdESService;
import eu.europa.esig.dss.cades.signature.CMSSignedDataBuilder;
import eu.europa.esig.dss.cades.signature.CMSSignedDocument;
import eu.europa.esig.dss.cades.validation.CMSDocumentValidator;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.model.SerializableCounterSignatureParameters;
import eu.europa.esig.dss.model.SerializableSignatureParameters;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.signature.SigningOperation;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.ValidationData;
import eu.europa.esig.dss.validation.ValidationDataContainer;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class ASiCWithCAdESService
extends AbstractASiCSignatureService<ASiCWithCAdESSignatureParameters, ASiCWithCAdESTimestampParameters, CAdESCounterSignatureParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCWithCAdESService.class);
    private static final String ZIP_ENTRY_ASICE_METAINF_CADES_TIMESTAMP = "META-INF/timestamp001.tst";
    private static final String DEFAULT_ARCHIVE_MANIFEST_FILENAME = "META-INF/ASiCArchiveManifest.xml";

    public ASiCWithCAdESService(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
        LOG.debug("+ ASiCService with CAdES created");
    }

    public TimestampToken getContentTimestamp(List<DSSDocument> toSignDocuments, ASiCWithCAdESSignatureParameters parameters) {
        GetDataToSignASiCWithCAdESHelper getDataToSignHelper = new ASiCWithCAdESDataToSignHelperBuilder().build(SigningOperation.SIGN, toSignDocuments, parameters);
        return this.getCAdESService().getContentTimestamp(getDataToSignHelper.getToBeSigned(), (CAdESSignatureParameters)parameters);
    }

    public ToBeSigned getDataToSign(List<DSSDocument> toSignDocuments, ASiCWithCAdESSignatureParameters parameters) {
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        if (Utils.isCollectionEmpty(toSignDocuments)) {
            throw new IllegalArgumentException("List of documents to sign cannot be empty!");
        }
        this.assertSigningDateInCertificateValidityRange((SerializableSignatureParameters)parameters);
        GetDataToSignASiCWithCAdESHelper dataToSignHelper = new ASiCWithCAdESDataToSignHelperBuilder().build(SigningOperation.SIGN, toSignDocuments, parameters);
        this.assertSignaturePossible(dataToSignHelper, parameters.aSiC());
        CAdESSignatureParameters cadesParameters = this.getCAdESParameters(parameters);
        cadesParameters.setDetachedContents(dataToSignHelper.getDetachedContents());
        return this.getCAdESService().getDataToSign(dataToSignHelper.getToBeSigned(), cadesParameters);
    }

    public DSSDocument signDocument(List<DSSDocument> toSignDocuments, ASiCWithCAdESSignatureParameters parameters, SignatureValue signatureValue) {
        Objects.requireNonNull(toSignDocuments, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        Objects.requireNonNull(signatureValue, "SignatureValue cannot be null!");
        if (Utils.isCollectionEmpty(toSignDocuments)) {
            throw new IllegalArgumentException("List of documents to sign cannot be empty!");
        }
        this.assertSigningDateInCertificateValidityRange((SerializableSignatureParameters)parameters);
        GetDataToSignASiCWithCAdESHelper dataToSignHelper = new ASiCWithCAdESDataToSignHelperBuilder().build(SigningOperation.SIGN, toSignDocuments, parameters);
        ASiCParameters asicParameters = parameters.aSiC();
        this.assertSignaturePossible(dataToSignHelper, asicParameters);
        DSSDocument documentToExtend = dataToSignHelper.getAsicContainer();
        List signatures = dataToSignHelper.getSignatures();
        List manifests = dataToSignHelper.getManifestFiles();
        List<DSSDocument> archiveManifests = dataToSignHelper.getArchiveManifestFiles();
        List<DSSDocument> timestamps = dataToSignHelper.getTimestamps();
        ArrayList<DSSDocument> extendedDocuments = new ArrayList<DSSDocument>();
        CAdESSignatureParameters cadesParameters = this.getCAdESParameters(parameters);
        cadesParameters.setDetachedContents(dataToSignHelper.getDetachedContents());
        boolean addASiCArchiveManifest = this.isAddASiCEArchiveManifest(parameters.getSignatureLevel(), parameters.aSiC().getContainerType());
        if (addASiCArchiveManifest) {
            cadesParameters.setSignatureLevel(SignatureLevel.CAdES_BASELINE_LT);
        }
        DSSDocument signature = this.getCAdESService().signDocument(dataToSignHelper.getToBeSigned(), cadesParameters, signatureValue);
        String newSignatureFileName = dataToSignHelper.getSignatureFilename();
        signature.setName(newSignatureFileName);
        if (ASiCUtils.isASiCS((ASiCParameters)asicParameters)) {
            Iterator iterator = signatures.iterator();
            while (iterator.hasNext()) {
                if (!Utils.areStringsEqual((String)newSignatureFileName, (String)((DSSDocument)iterator.next()).getName())) continue;
                iterator.remove();
            }
        }
        extendedDocuments.add(signature);
        if (documentToExtend == null) {
            documentToExtend = signature;
        }
        if (addASiCArchiveManifest) {
            this.extendWithArchiveManifest(documentToExtend, archiveManifests, manifests, timestamps, dataToSignHelper.getSignedDocuments(), extendedDocuments, parameters.getArchiveTimestampParameters().getDigestAlgorithm());
            cadesParameters.setSignatureLevel(SignatureLevel.CAdES_BASELINE_LTA);
        }
        ArrayList<DSSDocument> documentsToStore = new ArrayList<DSSDocument>(manifests);
        documentsToStore.addAll(archiveManifests);
        documentsToStore.addAll(timestamps);
        documentsToStore.addAll(signatures);
        this.excludeExtendedDocuments(documentsToStore, extendedDocuments);
        DSSDocument asicContainer = this.buildASiCContainer(dataToSignHelper.getSignedDocuments(), extendedDocuments, documentsToStore, asicParameters, parameters.getZipCreationDate());
        asicContainer.setName(this.getFinalDocumentName(asicContainer, SigningOperation.SIGN, parameters.getSignatureLevel(), asicContainer.getMimeType()));
        parameters.reinitDeterministicId();
        return asicContainer;
    }

    public DSSDocument timestamp(List<DSSDocument> toTimestampDocuments, ASiCWithCAdESTimestampParameters parameters) {
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        if (Utils.isCollectionEmpty(toTimestampDocuments)) {
            throw new IllegalArgumentException("List of documents to be timestamped cannot be empty!");
        }
        GetDataToSignASiCWithCAdESHelper dataToSignHelper = new ASiCWithCAdESDataToSignHelperBuilder().build(SigningOperation.TIMESTAMP, toTimestampDocuments, parameters);
        ASiCParameters asicParameters = parameters.aSiC();
        this.assertTimestampPossible(dataToSignHelper, asicParameters);
        List<DSSDocument> timestamps = dataToSignHelper.getTimestamps();
        ArrayList<DSSDocument> extendedDocuments = new ArrayList<DSSDocument>();
        if (Utils.collectionSize(timestamps) > 0) {
            DSSDocument toTimestampDocument = toTimestampDocuments.get(0);
            this.extractCurrentArchive(toTimestampDocument);
            this.extendWithArchiveManifest(toTimestampDocument, this.getEmbeddedArchiveManifests(), this.getEmbeddedManifests(), this.getEmbeddedTimestamps(), this.getEmbeddedSignedDocuments(), extendedDocuments, parameters.getDigestAlgorithm());
            DSSDocument extensionResult = this.mergeArchiveAndExtendedSignatures(toTimestampDocument, extendedDocuments, parameters.getZipCreationDate(), ASiCUtils.getZipComment((ASiCParameters)asicParameters));
            extensionResult.setName(this.getFinalDocumentName(toTimestampDocument, SigningOperation.TIMESTAMP, null, toTimestampDocument.getMimeType()));
            return extensionResult;
        }
        List signatures = dataToSignHelper.getSignatures();
        List manifests = dataToSignHelper.getManifestFiles();
        List<DSSDocument> archiveManifests = dataToSignHelper.getArchiveManifestFiles();
        DSSDocument toBeSigned = dataToSignHelper.getToBeSigned();
        DigestAlgorithm digestAlgorithm = parameters.getDigestAlgorithm();
        TimestampBinary timestampBinary = this.tspSource.getTimeStampResponse(digestAlgorithm, Utils.fromBase64((String)toBeSigned.getDigest(digestAlgorithm)));
        InMemoryDocument timestampToken = new InMemoryDocument(DSSASN1Utils.getDEREncoded((TimestampBinary)timestampBinary), dataToSignHelper.getTimestampFilename(), MimeType.TST);
        if (ASiCUtils.isASiCS((ASiCParameters)asicParameters)) {
            Iterator iterator = signatures.iterator();
            while (iterator.hasNext()) {
                if (!Utils.areStringsEqual((String)timestampToken.getName(), (String)((DSSDocument)iterator.next()).getName())) continue;
                iterator.remove();
            }
        }
        extendedDocuments.add((DSSDocument)timestampToken);
        ArrayList<DSSDocument> documentsToStore = new ArrayList<DSSDocument>(manifests);
        documentsToStore.addAll(archiveManifests);
        documentsToStore.addAll(timestamps);
        documentsToStore.addAll(signatures);
        this.excludeExtendedDocuments(documentsToStore, extendedDocuments);
        DSSDocument asicContainer = this.buildASiCContainer(dataToSignHelper.getSignedDocuments(), extendedDocuments, documentsToStore, asicParameters, parameters.getZipCreationDate());
        asicContainer.setName(this.getFinalDocumentName(asicContainer, SigningOperation.TIMESTAMP, null, asicContainer.getMimeType()));
        return asicContainer;
    }

    private void excludeExtendedDocuments(List<DSSDocument> documentListToCheck, List<DSSDocument> extendedDocuments) {
        List extendedDocumentNames = DSSUtils.getDocumentNames(extendedDocuments);
        Iterator<DSSDocument> iterator = documentListToCheck.iterator();
        while (iterator.hasNext()) {
            DSSDocument document = iterator.next();
            if (!extendedDocumentNames.contains(document.getName())) continue;
            iterator.remove();
        }
    }

    public DSSDocument extendDocument(DSSDocument toExtendDocument, ASiCWithCAdESSignatureParameters parameters) {
        Objects.requireNonNull(toExtendDocument, "toExtendDocument is not defined!");
        Objects.requireNonNull(parameters, "Cannot extend the signature. SignatureParameters are not defined!");
        this.assertExtensionSupported(toExtendDocument);
        this.extractCurrentArchive(toExtendDocument);
        List signatureDocuments = this.getEmbeddedSignatures();
        this.assertValidSignaturesToExtendFound(signatureDocuments);
        List originalSignedDocuments = this.getEmbeddedSignedDocuments();
        DSSDocument mimetype = this.getEmbeddedMimetype();
        ASiCContainerType containerType = ASiCUtils.getContainerType((DSSDocument)toExtendDocument, (DSSDocument)mimetype, null, (List)originalSignedDocuments);
        if (containerType == null) {
            throw new IllegalInputException("The container type of the provided document is not supported or cannot be extracted!");
        }
        ArrayList<DSSDocument> extendedDocuments = new ArrayList<DSSDocument>();
        CAdESSignatureParameters cadesParameters = this.getCAdESParameters(parameters);
        boolean addASiCEArchiveManifest = this.isAddASiCEArchiveManifest(parameters.getSignatureLevel(), containerType);
        if (addASiCEArchiveManifest) {
            cadesParameters.setSignatureLevel(SignatureLevel.CAdES_BASELINE_LT);
        }
        for (DSSDocument signature : signatureDocuments) {
            if (!addASiCEArchiveManifest || !this.isCoveredByArchiveManifest(signature)) {
                DSSDocument extendedSignature = this.extendSignatureDocument(signature, cadesParameters, containerType);
                extendedDocuments.add(extendedSignature);
                continue;
            }
            extendedDocuments.add(signature);
        }
        if (addASiCEArchiveManifest) {
            this.extendWithArchiveManifest(toExtendDocument, this.getEmbeddedArchiveManifests(), this.getEmbeddedManifests(), this.getEmbeddedTimestamps(), this.getEmbeddedSignedDocuments(), extendedDocuments, parameters.getDigestAlgorithm());
            cadesParameters.setSignatureLevel(SignatureLevel.CAdES_BASELINE_LTA);
        }
        DSSDocument extensionResult = this.mergeArchiveAndExtendedSignatures(toExtendDocument, extendedDocuments, parameters.getZipCreationDate(), ASiCUtils.getZipComment((ASiCParameters)parameters.aSiC()));
        extensionResult.setName(this.getFinalDocumentName(toExtendDocument, SigningOperation.EXTEND, parameters.getSignatureLevel(), toExtendDocument.getMimeType()));
        return extensionResult;
    }

    private void assertExtensionSupported(DSSDocument toExtendDocument) {
        if (!ASiCUtils.isZip((DSSDocument)toExtendDocument)) {
            throw new IllegalInputException("Unsupported file type");
        }
    }

    private void assertValidSignaturesToExtendFound(List<DSSDocument> signatureDocuments) {
        if (Utils.isCollectionEmpty(signatureDocuments)) {
            throw new IllegalInputException("No supported signature documents found! Unable to extend the container.");
        }
    }

    private boolean isCoveredByArchiveManifest(DSSDocument signature) {
        return ASiCWithCAdESExtractResultUtils.isCoveredByManifest(this.archiveContent, signature.getName());
    }

    private DSSDocument extendSignatureDocument(DSSDocument signature, CAdESSignatureParameters cadesParameters, ASiCContainerType containerType) {
        List manifests = this.getEmbeddedManifests();
        List originalSignedDocuments = this.getEmbeddedSignedDocuments();
        if (ASiCContainerType.ASiC_E == containerType) {
            DSSDocument linkedManifest = ASiCWithCAdESManifestParser.getLinkedManifest(manifests, signature.getName());
            if (linkedManifest != null) {
                String originalName = signature.getName();
                cadesParameters.setDetachedContents(Arrays.asList(linkedManifest));
                DSSDocument extendDocument = this.getCAdESService().extendDocument(signature, cadesParameters);
                extendDocument.setName(originalName);
                return extendDocument;
            }
            LOG.warn("Manifest not found for signature file '{}' -> NOT EXTENDED !!!", (Object)signature.getName());
            return signature;
        }
        String originalName = signature.getName();
        cadesParameters.setDetachedContents(originalSignedDocuments);
        DSSDocument extendDocument = this.getCAdESService().extendDocument(signature, cadesParameters);
        extendDocument.setName(originalName);
        return extendDocument;
    }

    private void extendWithArchiveManifest(DSSDocument toExtendDocument, List<DSSDocument> archiveManifests, List<DSSDocument> manifests, List<DSSDocument> timestamps, List<DSSDocument> originalSignedDocuments, List<DSSDocument> extendedDocuments, DigestAlgorithm digestAlgorithm) {
        String timestampFilename = this.getArchiveTimestampFilename(timestamps);
        manifests.addAll(archiveManifests);
        ManifestFile lastManifestFile = this.getLastManifestFile(manifests);
        DSSDocument lastTimestamp = this.getLastTimestampDocument(lastManifestFile, timestamps);
        if (lastTimestamp != null) {
            ASiCContainerWithCAdESValidator validator = new ASiCContainerWithCAdESValidator(toExtendDocument);
            validator.setCertificateVerifier(this.certificateVerifier);
            List allSignatures = validator.getAllSignatures();
            List<TimestampToken> detachedTimestamps = validator.getDetachedTimestamps();
            ValidationDataContainer validationDataContainer = validator.getValidationData(allSignatures, detachedTimestamps);
            ValidationData allValidationData = validationDataContainer.getAllValidationData();
            if (Utils.isCollectionNotEmpty(extendedDocuments)) {
                for (DSSDocument documentToExtend : extendedDocuments) {
                    allSignatures.addAll(new CMSDocumentValidator(documentToExtend).getSignatures());
                }
            }
            for (AdvancedSignature signature : allSignatures) {
                allValidationData.excludeCertificateTokens((Collection)signature.getCompleteCertificateSource().getAllCertificateTokens());
                allValidationData.excludeCRLTokens((Collection)signature.getCompleteCRLSource().getAllRevocationBinaries());
                allValidationData.excludeOCSPTokens((Collection)signature.getCompleteOCSPSource().getAllRevocationBinaries());
            }
            for (TimestampToken timestampToken : detachedTimestamps) {
                allValidationData.excludeCertificateTokens((Collection)timestampToken.getCertificateSource().getCertificates());
                allValidationData.excludeCRLTokens((Collection)timestampToken.getCRLSource().getAllRevocationBinaries());
                allValidationData.excludeOCSPTokens((Collection)timestampToken.getOCSPSource().getAllRevocationBinaries());
            }
            DSSDocument extendedTimestamp = this.extendTimestamp(lastTimestamp, allValidationData);
            timestamps.remove(lastTimestamp);
            extendedDocuments.add(extendedTimestamp);
        }
        DSSDocument lastArchiveManifest = null;
        if (lastManifestFile != null && this.isLastArchiveManifest(lastManifestFile.getFilename())) {
            lastArchiveManifest = lastManifestFile.getDocument();
            manifests.remove(lastArchiveManifest);
            lastArchiveManifest.setName(ASiCUtils.getNextASiCManifestName((String)"ASiCArchiveManifest", archiveManifests));
        }
        ASiCEWithCAdESArchiveManifestBuilder builder = new ASiCEWithCAdESArchiveManifestBuilder(extendedDocuments, timestamps, originalSignedDocuments, manifests, lastArchiveManifest, digestAlgorithm, timestampFilename);
        DSSDocument archiveManifest = DomUtils.createDssDocumentFromDomDocument((Document)builder.build(), (String)DEFAULT_ARCHIVE_MANIFEST_FILENAME);
        extendedDocuments.add(archiveManifest);
        if (lastArchiveManifest != null) {
            extendedDocuments.add(lastArchiveManifest);
        }
        TimestampBinary timeStampResponse = this.tspSource.getTimeStampResponse(digestAlgorithm, DSSUtils.digest((DigestAlgorithm)digestAlgorithm, (DSSDocument)archiveManifest));
        InMemoryDocument timestamp = new InMemoryDocument(DSSASN1Utils.getDEREncoded((TimestampBinary)timeStampResponse), timestampFilename, MimeType.TST);
        extendedDocuments.add((DSSDocument)timestamp);
    }

    private String getArchiveTimestampFilename(List<DSSDocument> timestamps) {
        int num = Utils.collectionSize(timestamps) + 1;
        return ZIP_ENTRY_ASICE_METAINF_CADES_TIMESTAMP.replace("001", ASiCUtils.getPadNumber((int)num));
    }

    private ManifestFile getLastManifestFile(List<DSSDocument> manifests) {
        DSSDocument lastManifest = this.getLastArchiveManifest(manifests);
        if (lastManifest == null) {
            lastManifest = DSSUtils.getDocumentWithLastName(manifests);
        }
        if (lastManifest != null) {
            return ASiCWithCAdESManifestParser.getManifestFile(lastManifest);
        }
        return null;
    }

    private DSSDocument getLastArchiveManifest(List<DSSDocument> manifests) {
        if (Utils.isCollectionNotEmpty(manifests)) {
            for (DSSDocument manifest : manifests) {
                if (!this.isLastArchiveManifest(manifest.getName())) continue;
                return manifest;
            }
        }
        return null;
    }

    private boolean isLastArchiveManifest(String fileName) {
        return DEFAULT_ARCHIVE_MANIFEST_FILENAME.equals(fileName);
    }

    private DSSDocument getLastTimestampDocument(ManifestFile lastManifestFile, List<DSSDocument> timestamps) {
        if (lastManifestFile != null) {
            return DSSUtils.getDocumentWithName(timestamps, (String)lastManifestFile.getSignatureFilename());
        }
        return DSSUtils.getDocumentWithLastName(timestamps);
    }

    private DSSDocument extendTimestamp(DSSDocument archiveTimestamp, ValidationData validationDataForInclusion) {
        CMSSignedData cmsSignedData = DSSUtils.toCMSSignedData((DSSDocument)archiveTimestamp);
        CMSSignedDataBuilder cmsSignedDataBuilder = new CMSSignedDataBuilder(this.certificateVerifier);
        CMSSignedData extendedCMSSignedData = cmsSignedDataBuilder.extendCMSSignedData(cmsSignedData, validationDataForInclusion);
        return new InMemoryDocument(DSSASN1Utils.getEncoded((CMSSignedData)extendedCMSSignedData), archiveTimestamp.getName(), MimeType.TST);
    }

    protected AbstractASiCContainerExtractor getArchiveExtractor(DSSDocument archive) {
        return new ASiCWithCAdESContainerExtractor(archive);
    }

    private CAdESService getCAdESService() {
        CAdESService cadesService = new CAdESService(this.certificateVerifier);
        cadesService.setTspSource(this.tspSource);
        return cadesService;
    }

    private CAdESSignatureParameters getCAdESParameters(ASiCWithCAdESSignatureParameters parameters) {
        ASiCWithCAdESSignatureParameters cadesParameters = parameters;
        cadesParameters.setSignaturePackaging(SignaturePackaging.DETACHED);
        cadesParameters.setDetachedContents(null);
        return cadesParameters;
    }

    private boolean isAddASiCEArchiveManifest(SignatureLevel signatureLevel, ASiCContainerType containerType) {
        return SignatureLevel.CAdES_BASELINE_LTA == signatureLevel && ASiCContainerType.ASiC_E == containerType;
    }

    protected String getExpectedSignatureExtension() {
        return ".p7s";
    }

    public DSSDocument addSignaturePolicyStore(DSSDocument asicContainer, SignaturePolicyStore signaturePolicyStore) {
        Objects.requireNonNull(asicContainer, "The asicContainer cannot be null");
        Objects.requireNonNull(signaturePolicyStore, "The signaturePolicyStore cannot be null");
        this.extractCurrentArchive(asicContainer);
        this.assertAddSignaturePolicyStorePossible();
        CAdESService cadesService = this.getCAdESService();
        ArrayList<DSSDocument> extendedSignatures = new ArrayList<DSSDocument>();
        for (DSSDocument signature : this.getEmbeddedSignatures()) {
            DSSDocument signatureWithPolicyStore = cadesService.addSignaturePolicyStore(signature, signaturePolicyStore);
            signatureWithPolicyStore.setName(signature.getName());
            extendedSignatures.add(signatureWithPolicyStore);
        }
        DSSDocument resultArchive = this.mergeArchiveAndExtendedSignatures(asicContainer, extendedSignatures, null, ASiCUtils.getZipComment((String)asicContainer.getMimeType().getMimeTypeString()));
        resultArchive.setName(this.getFinalArchiveName(asicContainer, SigningOperation.ADD_SIG_POLICY_STORE, asicContainer.getMimeType()));
        return resultArchive;
    }

    protected void assertAddSignaturePolicyStorePossible() {
        super.assertAddSignaturePolicyStorePossible();
        for (DSSDocument signature : this.getEmbeddedSignatures()) {
            if (!this.isCoveredByArchiveManifest(signature)) continue;
            throw new IllegalInputException(String.format("Not possible to add a signature policy store! Reason : a signature with a filename '%s' is covered by another manifest.", signature.getName()));
        }
    }

    public ToBeSigned getDataToBeCounterSigned(DSSDocument asicContainer, CAdESCounterSignatureParameters parameters) {
        Objects.requireNonNull(asicContainer, "asicContainer cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        this.assertSigningDateInCertificateValidityRange((SerializableSignatureParameters)parameters);
        this.assertCounterSignatureParametersValid(parameters);
        ASiCWithCAdESCounterSignatureHelper counterSignatureHelper = new ASiCWithCAdESCounterSignatureHelper(asicContainer);
        DSSDocument signatureDocument = counterSignatureHelper.extractSignatureDocument(parameters.getSignatureIdToCounterSign());
        CAdESCounterSignatureBuilder counterSignatureBuilder = new CAdESCounterSignatureBuilder(this.certificateVerifier);
        counterSignatureBuilder.setManifestFile(counterSignatureHelper.getManifestFile(signatureDocument.getName()));
        SignerInformation signerInfoToCounterSign = counterSignatureBuilder.getSignerInformationToBeCounterSigned(signatureDocument, parameters);
        CAdESService cadesService = this.getCAdESService();
        return cadesService.getDataToBeCounterSigned(signatureDocument, signerInfoToCounterSign, (CAdESSignatureParameters)parameters);
    }

    public DSSDocument counterSignSignature(DSSDocument asicContainer, CAdESCounterSignatureParameters parameters, SignatureValue signatureValue) {
        Objects.requireNonNull(asicContainer, "asicContainer cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        Objects.requireNonNull(signatureValue, "signatureValue cannot be null!");
        this.assertCounterSignatureParametersValid(parameters);
        ASiCWithCAdESCounterSignatureHelper counterSignatureHelper = new ASiCWithCAdESCounterSignatureHelper(asicContainer);
        DSSDocument signatureDocument = counterSignatureHelper.extractSignatureDocument(parameters.getSignatureIdToCounterSign());
        CMSSignedData originalCMSSignedData = DSSUtils.toCMSSignedData((DSSDocument)signatureDocument);
        CAdESCounterSignatureBuilder counterSignatureBuilder = new CAdESCounterSignatureBuilder(this.certificateVerifier);
        counterSignatureBuilder.setManifestFile(counterSignatureHelper.getManifestFile(signatureDocument.getName()));
        CMSSignedDocument counterSignedSignature = counterSignatureBuilder.addCounterSignature(originalCMSSignedData, parameters, signatureValue);
        counterSignedSignature.setName(signatureDocument.getName());
        List newSignaturesList = counterSignatureHelper.getUpdatedSignatureDocumentsList((DSSDocument)counterSignedSignature);
        DSSDocument resultArchive = this.mergeArchiveAndExtendedSignatures(asicContainer, newSignaturesList, parameters.bLevel().getSigningDate(), ASiCUtils.getZipComment((String)asicContainer.getMimeType().getMimeTypeString()));
        resultArchive.setName(this.getFinalDocumentName(asicContainer, SigningOperation.COUNTER_SIGN, parameters.getSignatureLevel(), asicContainer.getMimeType()));
        return resultArchive;
    }

    protected void assertCounterSignatureParametersValid(CAdESCounterSignatureParameters parameters) {
        super.assertCounterSignatureParametersValid((SerializableCounterSignatureParameters)parameters);
        if (!SignatureLevel.CAdES_BASELINE_B.equals((Object)parameters.getSignatureLevel())) {
            throw new UnsupportedOperationException(String.format("A counter signature with a level '%s' is not supported! Please, use CAdES-BASELINE-B", parameters.getSignatureLevel()));
        }
    }

    private void assertTimestampPossible(GetDataToSignASiCWithCAdESHelper dataToSignHelper, ASiCParameters asicParameters) {
        if (ASiCUtils.isASiCS((ASiCParameters)asicParameters) && Utils.isCollectionNotEmpty((Collection)dataToSignHelper.getSignatures())) {
            throw new IllegalInputException("Unable to timestamp an ASiC-S with CAdES container containing signature files! Use extendDocument(...) method for signature extension.");
        }
    }

    private void assertSignaturePossible(GetDataToSignASiCWithCAdESHelper dataToSignHelper, ASiCParameters asicParameters) {
        if (ASiCUtils.isASiCS((ASiCParameters)asicParameters) && Utils.isCollectionNotEmpty(dataToSignHelper.getTimestamps())) {
            throw new IllegalInputException("Unable to sign an ASiC-S with CAdES container containing time assertion files!");
        }
    }
}

