/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESContainerExtractor;
import eu.europa.esig.dss.asic.cades.validation.ASiCWithCAdESExtractResultUtils;
import eu.europa.esig.dss.asic.cades.validation.ASiCWithCAdESManifestParser;
import eu.europa.esig.dss.asic.common.ASiCExtractResult;
import eu.europa.esig.dss.asic.common.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.signature.ASiCCounterSignatureHelper;
import eu.europa.esig.dss.cades.validation.CMSDocumentValidator;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.validation.DocumentValidator;
import eu.europa.esig.dss.validation.ManifestFile;
import java.util.Collections;
import java.util.List;

public class ASiCWithCAdESCounterSignatureHelper
extends ASiCCounterSignatureHelper {
    protected ASiCWithCAdESCounterSignatureHelper(DSSDocument asicContainer) {
        super(asicContainer);
    }

    protected AbstractASiCContainerExtractor getASiCContainerExtractor() {
        return new ASiCWithCAdESContainerExtractor(this.asicContainer);
    }

    protected DocumentValidator getDocumentValidator(DSSDocument signatureDocument) {
        return new CMSDocumentValidator(signatureDocument);
    }

    protected List<DSSDocument> getDetachedDocuments(String signatureFilename) {
        ASiCExtractResult extractResult = this.getASiCExtractResult();
        DSSDocument signedDocument = ASiCWithCAdESExtractResultUtils.getSignedDocument(extractResult, signatureFilename);
        if (signedDocument != null) {
            return Collections.singletonList(signedDocument);
        }
        return Collections.emptyList();
    }

    public ManifestFile getManifestFile(String signatureFilename) {
        ASiCExtractResult extractResult = this.getASiCExtractResult();
        DSSDocument signatureManifest = ASiCWithCAdESManifestParser.getLinkedManifest(extractResult.getAllManifestDocuments(), signatureFilename);
        if (signatureManifest != null) {
            return ASiCWithCAdESManifestParser.getManifestFile(signatureManifest);
        }
        return null;
    }

    protected void checkCounterSignaturePossible(DSSDocument signatureDocument) {
        super.checkCounterSignaturePossible(signatureDocument);
        if (ASiCWithCAdESExtractResultUtils.isCoveredByManifest(this.getASiCExtractResult(), signatureDocument.getName())) {
            throw new IllegalInputException(String.format("The counter signature is not possible! Reason : a signature with a filename '%s' is covered by another manifest.", signatureDocument.getName()));
        }
    }
}

