/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.validation;

import eu.europa.esig.dss.asic.cades.validation.ASiCEWithCAdESManifestParser;
import eu.europa.esig.dss.asic.common.ASiCExtractResult;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.ManifestEntry;
import eu.europa.esig.dss.validation.ManifestFile;
import java.util.Collection;
import java.util.List;

public class ASiCWithCAdESExtractResultUtils {
    private ASiCWithCAdESExtractResultUtils() {
    }

    public static DSSDocument getSignedDocument(ASiCExtractResult extractResult, String signatureFilename) {
        ASiCContainerType type = extractResult.getContainerType();
        if (ASiCContainerType.ASiC_S.equals((Object)type) && extractResult.getSignedDocuments().size() == 1) {
            return (DSSDocument)extractResult.getSignedDocuments().iterator().next();
        }
        if (ASiCContainerType.ASiC_E.equals((Object)type)) {
            List manifestDocuments = extractResult.getManifestDocuments();
            if (manifestDocuments.size() == 1) {
                return (DSSDocument)manifestDocuments.iterator().next();
            }
            DSSDocument linkedManifest = ASiCEWithCAdESManifestParser.getLinkedManifest(extractResult.getManifestDocuments(), signatureFilename);
            if (linkedManifest != null) {
                return linkedManifest;
            }
            return null;
        }
        throw new DSSException("Unable to extract a signed document. Reason : Unknown asic container type.");
    }

    public static boolean isCoveredByManifest(ASiCExtractResult extractResult, String signatureFilename) {
        List manifests = extractResult.getAllManifestDocuments();
        if (Utils.isCollectionNotEmpty((Collection)manifests)) {
            for (DSSDocument archiveManifest : manifests) {
                ManifestFile manifestFile = ASiCEWithCAdESManifestParser.getManifestFile(archiveManifest);
                for (ManifestEntry entry : manifestFile.getEntries()) {
                    if (signatureFilename == null || !signatureFilename.equals(entry.getFileName())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

