/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.validation;

import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.ManifestEntry;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.scope.FullSignatureScope;
import eu.europa.esig.dss.validation.scope.ManifestSignatureScope;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import eu.europa.esig.dss.validation.timestamp.DetachedTimestampValidator;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ASiCEWithCAdESTimestampValidator
extends DetachedTimestampValidator {
    private final ManifestFile manifestFile;
    private final List<DSSDocument> originalDocuments;

    public ASiCEWithCAdESTimestampValidator(DSSDocument timestamp, TimestampType type, ManifestFile validatedManifestFile, List<DSSDocument> originalDocuments) {
        super(timestamp, type);
        Objects.requireNonNull(validatedManifestFile, "The validated ManifestFile must be defined!");
        this.manifestFile = validatedManifestFile;
        this.originalDocuments = originalDocuments;
    }

    public ManifestFile getCoveredManifest() {
        return this.manifestFile;
    }

    public TimestampToken getTimestamp() {
        TimestampToken timestamp = super.getTimestamp();
        timestamp.setManifestFile(this.getCoveredManifest());
        timestamp.setArchiveTimestampType(ArchiveTimestampType.CAdES_DETACHED);
        timestamp.setTimestampScopes(this.getTimestampSignatureScopes());
        return timestamp;
    }

    protected List<SignatureScope> getTimestampSignatureScopes() {
        ArrayList<SignatureScope> result = new ArrayList<SignatureScope>();
        result.add((SignatureScope)new ManifestSignatureScope(this.manifestFile.getFilename(), DSSUtils.getDigest((DigestAlgorithm)this.getDefaultDigestAlgorithm(), (DSSDocument)this.getTimestampedData())));
        if (Utils.isCollectionNotEmpty(this.originalDocuments)) {
            for (ManifestEntry manifestEntry : this.manifestFile.getEntries()) {
                for (DSSDocument document : this.originalDocuments) {
                    if (!Utils.areStringsEqual((String)manifestEntry.getFileName(), (String)document.getName())) continue;
                    result.add((SignatureScope)new FullSignatureScope(manifestEntry.getFileName(), DSSUtils.getDigest((DigestAlgorithm)this.getDefaultDigestAlgorithm(), (DSSDocument)document)));
                }
            }
        }
        return result;
    }
}

