/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.validation;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESContainerExtractor;
import eu.europa.esig.dss.asic.cades.validation.ASiCEWithCAdESManifestParser;
import eu.europa.esig.dss.asic.cades.validation.ASiCEWithCAdESManifestValidator;
import eu.europa.esig.dss.asic.cades.validation.ASiCEWithCAdESTimestampValidator;
import eu.europa.esig.dss.asic.cades.validation.ASiCWithCAdESDiagnosticDataBuilder;
import eu.europa.esig.dss.asic.cades.validation.ASiCWithCAdESExtractResultUtils;
import eu.europa.esig.dss.asic.cades.validation.scope.ASiCWithCAdESSignatureScopeFinder;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.ZipUtils;
import eu.europa.esig.dss.asic.common.validation.AbstractASiCContainerValidator;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.CMSDocumentValidator;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.DocumentValidator;
import eu.europa.esig.dss.validation.ManifestEntry;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.scope.SignatureScopeFinder;
import eu.europa.esig.dss.validation.timestamp.DetachedTimestampValidator;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASiCContainerWithCAdESValidator
extends AbstractASiCContainerValidator {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCContainerWithCAdESValidator.class);

    ASiCContainerWithCAdESValidator() {
        super(null);
    }

    public ASiCContainerWithCAdESValidator(DSSDocument asicContainer) {
        super(asicContainer, (SignatureScopeFinder)new ASiCWithCAdESSignatureScopeFinder());
        this.extractEntries();
    }

    public boolean isSupported(DSSDocument dssDocument) {
        if (ASiCUtils.isZip((DSSDocument)dssDocument)) {
            List filenames = ZipUtils.getInstance().extractEntryNames(dssDocument);
            return ASiCUtils.isASiCWithCAdES((List)filenames);
        }
        return false;
    }

    protected AbstractASiCContainerExtractor getContainerExtractor() {
        return new ASiCWithCAdESContainerExtractor(this.document);
    }

    protected List<DocumentValidator> getSignatureValidators() {
        if (this.signatureValidators == null) {
            this.signatureValidators = new ArrayList();
            for (DSSDocument signature : this.getSignatureDocuments()) {
                DSSDocument signatureManifest;
                CMSDocumentValidator cadesValidator = new CMSDocumentValidator(signature);
                cadesValidator.setCertificateVerifier(this.certificateVerifier);
                cadesValidator.setProcessExecutor(this.processExecutor);
                cadesValidator.setSignaturePolicyProvider(this.getSignaturePolicyProvider());
                cadesValidator.setContainerContents(this.getArchiveDocuments());
                DSSDocument signedDocument = ASiCWithCAdESExtractResultUtils.getSignedDocument(this.extractResult, signature.getName());
                if (signedDocument != null) {
                    cadesValidator.setDetachedContents(Collections.singletonList(signedDocument));
                }
                if ((signatureManifest = ASiCEWithCAdESManifestParser.getLinkedManifest(this.getAllManifestDocuments(), signature.getName())) != null) {
                    ManifestFile manifestFile = this.toValidatedManifestFile(signatureManifest);
                    cadesValidator.setManifestFile(manifestFile);
                }
                this.signatureValidators.add(cadesValidator);
            }
        }
        return this.signatureValidators;
    }

    protected List<DocumentValidator> getTimestampValidators() {
        if (this.timestampValidators == null) {
            this.timestampValidators = new ArrayList();
            for (DSSDocument timestamp : this.getTimestampDocuments()) {
                DetachedTimestampValidator timestampValidator;
                DSSDocument archiveManifest = ASiCEWithCAdESManifestParser.getLinkedManifest(this.getAllManifestDocuments(), timestamp.getName());
                if (archiveManifest != null) {
                    ManifestFile validatedManifestFile = this.toValidatedManifestFile(archiveManifest);
                    if (validatedManifestFile != null) {
                        timestampValidator = new ASiCEWithCAdESTimestampValidator(timestamp, this.getTimestampType(validatedManifestFile), validatedManifestFile, this.getAllDocuments());
                        timestampValidator.setTimestampedData(archiveManifest);
                        timestampValidator.setCertificateVerifier(this.certificateVerifier);
                        this.timestampValidators.add(timestampValidator);
                        continue;
                    }
                    LOG.warn("A linked manifest is not found for a timestamp with name [{}]!", (Object)archiveManifest.getName());
                    continue;
                }
                List signedDocuments = this.getSignedDocuments();
                if (Utils.collectionSize((Collection)signedDocuments) == 1) {
                    timestampValidator = new DetachedTimestampValidator(timestamp);
                    timestampValidator.setTimestampedData((DSSDocument)signedDocuments.get(0));
                    timestampValidator.setCertificateVerifier(this.certificateVerifier);
                    this.timestampValidators.add(timestampValidator);
                    continue;
                }
                LOG.warn("Timestamp {} is skipped (no linked archive manifest found / unique file)", (Object)timestamp.getName());
            }
        }
        return this.timestampValidators;
    }

    public List<TimestampToken> getDetachedTimestamps() {
        ArrayList<TimestampToken> independantTimestamps = new ArrayList<TimestampToken>();
        for (DocumentValidator timestampValidator : this.getTimestampValidators()) {
            independantTimestamps.addAll(timestampValidator.getDetachedTimestamps());
        }
        return independantTimestamps;
    }

    public List<DSSDocument> getArchiveDocuments() {
        List archiveContents = super.getArchiveDocuments();
        if (Utils.isCollectionNotEmpty((Collection)this.getManifestDocuments())) {
            for (DSSDocument document : this.getAllDocuments()) {
                if (archiveContents.contains(document)) continue;
                archiveContents.add(document);
            }
        }
        return archiveContents;
    }

    protected List<TimestampToken> attachExternalTimestamps(List<AdvancedSignature> allSignatures) {
        ArrayList<TimestampToken> externalTimestamps = new ArrayList<TimestampToken>();
        List<DocumentValidator> currentTimestampValidators = this.getTimestampValidators();
        for (DocumentValidator tspValidator : currentTimestampValidators) {
            TimestampToken timestamp = this.getExternalTimestamp(tspValidator, allSignatures);
            if (timestamp == null) continue;
            externalTimestamps.add(timestamp);
        }
        return externalTimestamps;
    }

    private TimestampToken getExternalTimestamp(DocumentValidator tspValidator, List<AdvancedSignature> allSignatures) {
        if (tspValidator instanceof ASiCEWithCAdESTimestampValidator) {
            ASiCEWithCAdESTimestampValidator manifestBasedTimestampValidator = (ASiCEWithCAdESTimestampValidator)tspValidator;
            TimestampToken timestamp = manifestBasedTimestampValidator.getTimestamp();
            ManifestFile coveredManifest = manifestBasedTimestampValidator.getCoveredManifest();
            for (ManifestEntry entry : coveredManifest.getEntries()) {
                for (AdvancedSignature advancedSignature : allSignatures) {
                    if (!Utils.areStringsEqual((String)entry.getFileName(), (String)advancedSignature.getSignatureFilename()) || advancedSignature.isCounterSignature()) continue;
                    CAdESSignature cadesSig = (CAdESSignature)advancedSignature;
                    timestamp.setArchiveTimestampType(ArchiveTimestampType.CAdES_DETACHED);
                    cadesSig.addExternalTimestamp(timestamp);
                }
            }
            return timestamp;
        }
        if (tspValidator instanceof DetachedTimestampValidator) {
            return ((DetachedTimestampValidator)tspValidator).getTimestamp();
        }
        return null;
    }

    private ManifestFile toValidatedManifestFile(DSSDocument manifest) {
        List manifestFiles = this.getManifestFiles();
        if (Utils.isCollectionNotEmpty((Collection)manifestFiles)) {
            for (ManifestFile manifestFile : manifestFiles) {
                if (!Utils.areStringsEqual((String)manifest.getName(), (String)manifestFile.getFilename())) continue;
                return manifestFile;
            }
        }
        return null;
    }

    private TimestampType getTimestampType(ManifestFile manifestFile) {
        return this.coversSignature(manifestFile) ? TimestampType.ARCHIVE_TIMESTAMP : TimestampType.CONTENT_TIMESTAMP;
    }

    private boolean coversSignature(ManifestFile manifestFile) {
        for (ManifestEntry manifestEntry : manifestFile.getEntries()) {
            if (!ASiCUtils.isSignature((String)manifestEntry.getFileName())) continue;
            return true;
        }
        return false;
    }

    protected List<ManifestFile> getManifestFilesDescriptions() {
        ArrayList<ManifestFile> descriptions = new ArrayList<ManifestFile>();
        List manifestDocuments = this.getManifestDocuments();
        for (DSSDocument manifestDocument : manifestDocuments) {
            ManifestFile manifestFile = ASiCEWithCAdESManifestParser.getManifestFile(manifestDocument);
            if (manifestFile == null) continue;
            ASiCEWithCAdESManifestValidator asiceWithCAdESManifestValidator = new ASiCEWithCAdESManifestValidator(manifestFile, this.getAllDocuments());
            asiceWithCAdESManifestValidator.validateEntries();
            descriptions.add(manifestFile);
        }
        List archiveManifestDocuments = this.getArchiveManifestDocuments();
        for (DSSDocument manifestDocument : archiveManifestDocuments) {
            ManifestFile manifestFile = ASiCEWithCAdESManifestParser.getManifestFile(manifestDocument);
            if (manifestFile == null) continue;
            manifestFile.setArchiveManifest(true);
            ASiCEWithCAdESManifestValidator asiceWithCAdESManifestValidator = new ASiCEWithCAdESManifestValidator(manifestFile, this.getAllDocuments());
            asiceWithCAdESManifestValidator.validateEntries();
            descriptions.add(manifestFile);
        }
        return descriptions;
    }

    public List<DSSDocument> getOriginalDocuments(String signatureId) {
        List signatures = this.getSignatures();
        for (AdvancedSignature signature : signatures) {
            if (!signature.getId().equals(signatureId)) continue;
            return this.getOriginalDocuments(signature);
        }
        return Collections.emptyList();
    }

    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        if (advancedSignature.isCounterSignature()) {
            CAdESSignature cadesSignature = (CAdESSignature)advancedSignature;
            return Arrays.asList(cadesSignature.getOriginalDocument());
        }
        List retrievedDocs = advancedSignature.getDetachedContents();
        if (ASiCContainerType.ASiC_S.equals((Object)this.getContainerType())) {
            return this.getSignedDocumentsASiCS(retrievedDocs);
        }
        DSSDocument linkedManifest = ASiCEWithCAdESManifestParser.getLinkedManifest(this.getManifestDocuments(), advancedSignature.getSignatureFilename());
        if (linkedManifest == null) {
            return Collections.emptyList();
        }
        ManifestFile manifestFile = ASiCEWithCAdESManifestParser.getManifestFile(linkedManifest);
        return this.getManifestedDocuments(manifestFile);
    }

    private List<DSSDocument> getManifestedDocuments(ManifestFile manifestFile) {
        List entries = manifestFile.getEntries();
        List signedDocuments = this.getAllDocuments();
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        for (ManifestEntry entry : entries) {
            for (DSSDocument signedDocument : signedDocuments) {
                if (!Utils.areStringsEqual((String)entry.getFileName(), (String)signedDocument.getName())) continue;
                result.add(signedDocument);
            }
        }
        return result;
    }

    protected ASiCWithCAdESDiagnosticDataBuilder initializeDiagnosticDataBuilder() {
        return new ASiCWithCAdESDiagnosticDataBuilder();
    }
}

