/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature.manifest;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.asic.cades.signature.manifest.AbstractManifestBuilder;
import eu.europa.esig.dss.asic.common.definition.ASiCElement;
import eu.europa.esig.dss.asic.common.definition.ASiCNamespace;
import eu.europa.esig.dss.definition.DSSElement;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.signature.SigningOperation;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ASiCEWithCAdESManifestBuilder
extends AbstractManifestBuilder {
    private final SigningOperation operation;
    private final List<DSSDocument> documents;
    private final DigestAlgorithm digestAlgorithm;
    private final String documentUri;

    public ASiCEWithCAdESManifestBuilder(SigningOperation operation, List<DSSDocument> documents, DigestAlgorithm digestAlgorithm, String documentUri) {
        this.operation = operation;
        this.documents = documents;
        this.digestAlgorithm = digestAlgorithm;
        this.documentUri = documentUri;
    }

    public Document build() {
        Document documentDom = DomUtils.buildDOM();
        Element asicManifestDom = DomUtils.createElementNS((Document)documentDom, (DSSNamespace)ASiCNamespace.NS, (DSSElement)ASiCElement.ASIC_MANIFEST);
        documentDom.appendChild(asicManifestDom);
        if (SigningOperation.SIGN == this.operation) {
            this.addSigReference(documentDom, asicManifestDom, this.documentUri, MimeType.PKCS7);
        } else {
            this.addSigReference(documentDom, asicManifestDom, this.documentUri, MimeType.TST);
        }
        for (DSSDocument document : this.documents) {
            this.addDataObjectReference(documentDom, asicManifestDom, document, this.digestAlgorithm);
        }
        return documentDom;
    }
}

