/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature.asics;

import eu.europa.esig.dss.asic.cades.signature.GetDataToSignASiCWithCAdESHelper;
import eu.europa.esig.dss.asic.cades.signature.asics.AbstractGetDataToSignASiCSWithCAdES;
import eu.europa.esig.dss.asic.common.ASiCExtractResult;
import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collections;
import java.util.List;

public class DataToSignASiCSWithCAdESFromArchive
extends AbstractGetDataToSignASiCSWithCAdES
implements GetDataToSignASiCWithCAdESHelper {
    private final List<DSSDocument> embeddedSignedFiles;
    private final List<DSSDocument> embeddedSignatures;
    private final List<DSSDocument> embeddedTimestamps;

    public DataToSignASiCSWithCAdESFromArchive(ASiCExtractResult result, ASiCParameters asicParameters) {
        super(asicParameters);
        this.embeddedSignedFiles = result.getSignedDocuments();
        this.embeddedSignatures = result.getSignatureDocuments();
        this.embeddedTimestamps = result.getTimestampDocuments();
    }

    public String getSignatureFilename() {
        return this.getSignatureFileName();
    }

    public String getTimestampFilename() {
        return this.getTimestampFileName();
    }

    @Override
    public DSSDocument getToBeSigned() {
        int nbEmbeddedSignatures = Utils.collectionSize(this.embeddedSignatures);
        if (nbEmbeddedSignatures != 1) {
            throw new DSSException("Unable to select the embedded signature (nb found:" + nbEmbeddedSignatures + ")");
        }
        return this.embeddedSignatures.get(0);
    }

    @Override
    public List<DSSDocument> getDetachedContents() {
        return this.getSignedDocuments();
    }

    public List<DSSDocument> getSignedDocuments() {
        int nbSignedFiles = Utils.collectionSize(this.embeddedSignedFiles);
        if (nbSignedFiles != 1) {
            throw new DSSException("Unable to select the document to be signed (nb found:" + nbSignedFiles + ")");
        }
        return this.embeddedSignedFiles;
    }

    public List<DSSDocument> getManifestFiles() {
        return Collections.emptyList();
    }

    public List<DSSDocument> getSignatures() {
        return this.embeddedSignatures;
    }

    @Override
    public List<DSSDocument> getArchiveManifestFiles() {
        return Collections.emptyList();
    }

    @Override
    public List<DSSDocument> getTimestamps() {
        return this.embeddedTimestamps;
    }
}

