/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.validation.scope;

import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.scope.CAdESSignatureScopeFinder;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.scope.ContainerContentSignatureScope;
import eu.europa.esig.dss.validation.scope.ContainerSignatureScope;
import eu.europa.esig.dss.validation.scope.FullSignatureScope;
import eu.europa.esig.dss.validation.scope.ManifestSignatureScope;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import java.util.ArrayList;
import java.util.List;

public class ASiCWithCAdESSignatureScopeFinder
extends CAdESSignatureScopeFinder {
    public List<SignatureScope> findSignatureScope(CAdESSignature cadesSignature) {
        ArrayList<SignatureScope> result = new ArrayList<SignatureScope>();
        DSSDocument originalDocument = this.getOriginalDocument(cadesSignature);
        if (originalDocument == null) {
            return result;
        }
        if (this.isASiCSArchive((AdvancedSignature)cadesSignature, originalDocument)) {
            result.add((SignatureScope)new ContainerSignatureScope(originalDocument.getName(), DSSUtils.getDigest((DigestAlgorithm)this.getDefaultDigestAlgorithm(), (DSSDocument)originalDocument)));
            for (DSSDocument archivedDocument : cadesSignature.getContainerContents()) {
                result.add((SignatureScope)new ContainerContentSignatureScope(DSSUtils.decodeUrl((String)archivedDocument.getName()), DSSUtils.getDigest((DigestAlgorithm)this.getDefaultDigestAlgorithm(), (DSSDocument)archivedDocument)));
            }
        } else if (this.isASiCEArchive((AdvancedSignature)cadesSignature)) {
            result.add((SignatureScope)new ManifestSignatureScope(originalDocument.getName(), DSSUtils.getDigest((DigestAlgorithm)this.getDefaultDigestAlgorithm(), (DSSDocument)originalDocument)));
            for (DSSDocument manifestContent : cadesSignature.getManifestedDocuments()) {
                result.add((SignatureScope)new FullSignatureScope(manifestContent.getName(), DSSUtils.getDigest((DigestAlgorithm)this.getDefaultDigestAlgorithm(), (DSSDocument)manifestContent)));
            }
        } else {
            return this.getSignatureScopeFromOriginalDocument(originalDocument);
        }
        return result;
    }
}

