/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.validation;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.definition.ASiCAttribute;
import eu.europa.esig.dss.asic.common.definition.ASiCNamespace;
import eu.europa.esig.dss.asic.common.definition.ASiCPaths;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigNamespace;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigPaths;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.ManifestEntry;
import eu.europa.esig.dss.validation.ManifestFile;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ASiCEWithCAdESManifestParser {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCEWithCAdESManifestParser.class);

    public static ManifestFile getManifestFile(DSSDocument manifestDocument) {
        Element root = ASiCEWithCAdESManifestParser.getManifestRootElement(manifestDocument);
        if (root == null) {
            return null;
        }
        ManifestFile manifest = new ManifestFile();
        manifest.setDocument(manifestDocument);
        manifest.setSignatureFilename(ASiCEWithCAdESManifestParser.getLinkedSignatureName(root));
        manifest.setEntries(ASiCEWithCAdESManifestParser.parseManifestEntries(root));
        manifest.setTimestampManifest(ASiCEWithCAdESManifestParser.isTimestampAssociatedManifest(root));
        manifest.setArchiveManifest(ASiCUtils.isArchiveManifest((String)manifestDocument.getName()));
        return manifest;
    }

    public static DSSDocument getLinkedManifest(List<DSSDocument> manifestDocuments, String signatureName) {
        for (DSSDocument manifest : manifestDocuments) {
            String linkedSignatureName;
            Element manifestRoot = ASiCEWithCAdESManifestParser.getManifestRootElement(manifest);
            if (manifestRoot == null || !signatureName.equals(linkedSignatureName = DSSUtils.decodeUrl((String)ASiCEWithCAdESManifestParser.getLinkedSignatureName(manifestRoot)))) continue;
            return manifest;
        }
        return null;
    }

    private static Element getManifestRootElement(DSSDocument manifestDocument) {
        Element element;
        block8: {
            InputStream is = manifestDocument.openStream();
            try {
                Document manifestDom = DomUtils.buildDOM((InputStream)is);
                element = DomUtils.getElement((Node)manifestDom, (String)ASiCPaths.ASIC_MANIFEST_PATH);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.warn("Unable to analyze manifest file '{}' : {}", (Object)manifestDocument.getName(), (Object)e.getMessage());
                    return null;
                }
            }
            is.close();
        }
        return element;
    }

    private static String getLinkedSignatureName(Element root) {
        return DomUtils.getValue((Node)root, (String)ASiCPaths.SIG_REFERENCE_URI_PATH);
    }

    private static MimeType getMimeType(Element element) {
        try {
            return MimeType.fromMimeTypeString((String)element.getAttribute(ASiCAttribute.MIME_TYPE.getAttributeName()));
        }
        catch (DSSException e) {
            LOG.warn("Cannot extract MimeType for a reference. Reason : [{}]", (Object)e.getMessage());
            return null;
        }
    }

    private static DigestAlgorithm getDigestAlgorithm(Element dataObjectReference) {
        String value = null;
        try {
            value = DomUtils.getValue((Node)dataObjectReference, (String)XMLDSigPaths.DIGEST_METHOD_ALGORITHM_PATH);
            return DigestAlgorithm.forXML((String)value);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Unable to extract DigestAlgorithm (value = {}). Reason : [{}]", (Object)value, (Object)e.getMessage());
            return null;
        }
    }

    private static byte[] getDigestValue(Element dataObjectReference) {
        Element digestValueElement = DomUtils.getElement((Node)dataObjectReference, (String)XMLDSigPaths.DIGEST_VALUE_PATH);
        if (digestValueElement != null) {
            try {
                return Utils.fromBase64((String)digestValueElement.getTextContent());
            }
            catch (Exception e) {
                LOG.warn("Unable to extract DigestValue. Reason : [{}]", (Object)e.getMessage());
            }
        }
        return null;
    }

    private static boolean isTimestampAssociatedManifest(Element root) {
        Element sigReference = DomUtils.getElement((Node)root, (String)ASiCPaths.SIG_REFERENCE_PATH);
        if (sigReference != null) {
            MimeType mimeType = ASiCEWithCAdESManifestParser.getMimeType(sigReference);
            return mimeType != null && MimeType.TST == mimeType;
        }
        return false;
    }

    private static List<ManifestEntry> parseManifestEntries(Element root) {
        ArrayList<ManifestEntry> entries = new ArrayList<ManifestEntry>();
        NodeList dataObjectReferences = DomUtils.getNodeList((Node)root, (String)ASiCPaths.DATA_OBJECT_REFERENCE_PATH);
        if (dataObjectReferences == null || dataObjectReferences.getLength() == 0) {
            LOG.warn("No DataObjectReference found in manifest file");
        } else {
            for (int i = 0; i < dataObjectReferences.getLength(); ++i) {
                String attribute;
                ManifestEntry entry = new ManifestEntry();
                Element dataObjectReference = (Element)dataObjectReferences.item(i);
                entry.setFileName(DSSUtils.decodeUrl((String)dataObjectReference.getAttribute(ASiCAttribute.URI.getAttributeName())));
                entry.setMimeType(ASiCEWithCAdESManifestParser.getMimeType(dataObjectReference));
                DigestAlgorithm digestAlgorithm = ASiCEWithCAdESManifestParser.getDigestAlgorithm(dataObjectReference);
                byte[] digestValueBinary = ASiCEWithCAdESManifestParser.getDigestValue(dataObjectReference);
                if (digestAlgorithm != null && digestValueBinary != null) {
                    entry.setDigest(new Digest(digestAlgorithm, digestValueBinary));
                }
                if (Utils.areStringsEqualIgnoreCase((String)"true", (String)(attribute = dataObjectReference.getAttribute(ASiCAttribute.ROOTFILE.getAttributeName())))) {
                    entry.setRootfile(true);
                }
                entries.add(entry);
            }
        }
        return entries;
    }

    static {
        DomUtils.registerNamespace((DSSNamespace)XMLDSigNamespace.NS);
        DomUtils.registerNamespace((DSSNamespace)ASiCNamespace.NS);
    }
}

