/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature.asice;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESCommonParameters;
import eu.europa.esig.dss.asic.cades.signature.GetDataToSignASiCWithCAdESHelper;
import eu.europa.esig.dss.asic.cades.signature.asice.AbstractDataToSignASiCEWithCAdES;
import eu.europa.esig.dss.asic.common.ASiCExtractResult;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.signature.SigningOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DataToSignASiCEWithCAdESFromArchive
extends AbstractDataToSignASiCEWithCAdES
implements GetDataToSignASiCWithCAdESHelper {
    private final SigningOperation operation;
    private final List<DSSDocument> signedDocuments;
    private final List<DSSDocument> existingSignatures;
    private final List<DSSDocument> existingManifests;
    private final List<DSSDocument> existingArchiveManifests;
    private final List<DSSDocument> existingTimestamps;
    private final ASiCWithCAdESCommonParameters parameters;
    private DSSDocument toBeSigned;

    public DataToSignASiCEWithCAdESFromArchive(SigningOperation operation, ASiCExtractResult extractionResult, ASiCWithCAdESCommonParameters parameters) {
        this.operation = operation;
        this.signedDocuments = extractionResult.getSignedDocuments();
        this.existingSignatures = extractionResult.getSignatureDocuments();
        this.existingManifests = extractionResult.getManifestDocuments();
        this.existingArchiveManifests = extractionResult.getArchiveManifestDocuments();
        this.existingTimestamps = extractionResult.getTimestampDocuments();
        this.parameters = parameters;
    }

    public String getSignatureFilename() {
        return this.getSignatureFileName(this.parameters.aSiC(), this.existingSignatures);
    }

    public String getTimestampFilename() {
        return this.getTimestampFileName(this.existingTimestamps);
    }

    @Override
    public DSSDocument getToBeSigned() {
        if (this.toBeSigned == null) {
            this.toBeSigned = this.getASiCManifest(this.operation, this.signedDocuments, this.existingSignatures, this.existingTimestamps, this.existingManifests, this.parameters);
        }
        return this.toBeSigned;
    }

    @Override
    public List<DSSDocument> getDetachedContents() {
        return Collections.emptyList();
    }

    public List<DSSDocument> getSignedDocuments() {
        return this.signedDocuments;
    }

    public List<DSSDocument> getManifestFiles() {
        ArrayList<DSSDocument> manifests = new ArrayList<DSSDocument>(this.existingManifests);
        manifests.add(this.getToBeSigned());
        return manifests;
    }

    public List<DSSDocument> getSignatures() {
        return this.existingSignatures;
    }

    @Override
    public List<DSSDocument> getArchiveManifestFiles() {
        return this.existingArchiveManifests;
    }

    @Override
    public List<DSSDocument> getTimestamps() {
        return this.existingTimestamps;
    }
}

