/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESCommonParameters;
import eu.europa.esig.dss.asic.cades.ASiCWithCAdESContainerExtractor;
import eu.europa.esig.dss.asic.cades.signature.GetDataToSignASiCWithCAdESHelper;
import eu.europa.esig.dss.asic.cades.signature.asice.DataToSignASiCEWithCAdESFromArchive;
import eu.europa.esig.dss.asic.cades.signature.asice.DataToSignASiCEWithCAdESFromFiles;
import eu.europa.esig.dss.asic.cades.signature.asics.DataToSignASiCSWithCAdESFromArchive;
import eu.europa.esig.dss.asic.cades.signature.asics.DataToSignASiCSWithCAdESFromFiles;
import eu.europa.esig.dss.asic.common.ASiCExtractResult;
import eu.europa.esig.dss.asic.common.ASiCParameters;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.signature.SigningOperation;
import java.util.List;

public class ASiCWithCAdESDataToSignHelperBuilder {
    private ASiCWithCAdESDataToSignHelperBuilder() {
    }

    public static GetDataToSignASiCWithCAdESHelper getGetDataToSignHelper(SigningOperation operation, List<DSSDocument> documents, ASiCWithCAdESCommonParameters parameters) {
        boolean asice = ASiCUtils.isASiCE((ASiCParameters)parameters.aSiC());
        boolean asic = ASiCUtils.isAsic(documents);
        if (asic) {
            DSSDocument archiveDoc = documents.get(0);
            if (!ASiCUtils.isArchiveContainsCorrectSignatureFileWithExtension((DSSDocument)archiveDoc, (String)".p7s") && !ASiCUtils.isArchiveContainsCorrectTimestamp((DSSDocument)archiveDoc)) {
                throw new UnsupportedOperationException("Container type doesn't match");
            }
            ASiCWithCAdESContainerExtractor extractor = new ASiCWithCAdESContainerExtractor(archiveDoc);
            ASiCExtractResult result = extractor.extract();
            ASiCContainerType currentContainerType = ASiCUtils.getContainerType((DSSDocument)archiveDoc, (DSSDocument)result.getMimeTypeDocument(), (String)result.getZipComment(), (List)result.getSignedDocuments());
            if (asice && ASiCContainerType.ASiC_E.equals((Object)currentContainerType)) {
                return new DataToSignASiCEWithCAdESFromArchive(operation, result, parameters);
            }
            if (!asice && ASiCContainerType.ASiC_S.equals((Object)currentContainerType)) {
                return new DataToSignASiCSWithCAdESFromArchive(result, parameters.aSiC());
            }
            throw new UnsupportedOperationException(String.format("Original container type '%s' vs parameter : '%s'", currentContainerType, parameters.aSiC().getContainerType()));
        }
        if (asice) {
            return new DataToSignASiCEWithCAdESFromFiles(operation, documents, parameters);
        }
        return new DataToSignASiCSWithCAdESFromFiles(documents, parameters.getZipCreationDate(), parameters.aSiC());
    }
}

