/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades;

import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.model.DSSDocument;

public class ASiCWithCAdESContainerExtractor
extends AbstractASiCContainerExtractor {
    public ASiCWithCAdESContainerExtractor(DSSDocument archive) {
        super(archive);
    }

    protected boolean isAllowedManifest(String entryName) {
        return entryName.startsWith("META-INF/") && entryName.contains("ASiCManifest") && entryName.endsWith(".xml");
    }

    protected boolean isAllowedArchiveManifest(String entryName) {
        return entryName.startsWith("META-INF/") && ASiCUtils.isArchiveManifest((String)entryName);
    }

    protected boolean isAllowedTimestamp(String entryName) {
        return entryName.startsWith("META-INF/") && entryName.contains("timestamp") && entryName.endsWith(".tst");
    }

    protected boolean isAllowedSignature(String entryName) {
        return ASiCUtils.isCAdES((String)entryName);
    }
}

