/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.validation;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.utils.Utils;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ASiCEWithCAdESManifestValidator {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCEWithCAdESManifestValidator.class);
    private final DSSDocument signature;
    private final List<DSSDocument> manifestDocuments;
    private final List<DSSDocument> signedDocuments;

    public ASiCEWithCAdESManifestValidator(DSSDocument signature, List<DSSDocument> manifestDocuments, List<DSSDocument> signedDocuments) {
        this.signature = signature;
        this.manifestDocuments = manifestDocuments;
        this.signedDocuments = signedDocuments;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DSSDocument getLinkedManifest() {
        String expectedSignatureURI = this.signature.getName();
        Iterator<DSSDocument> iterator = this.manifestDocuments.iterator();
        while (iterator.hasNext()) {
            DSSDocument manifestDocument = iterator.next();
            try {
                InputStream is = manifestDocument.openStream();
                Throwable throwable = null;
                try {
                    Document manifestDom = DomUtils.buildDOM((InputStream)is);
                    Element root = DomUtils.getElement((Node)manifestDom, (String)"asic:ASiCManifest");
                    String signatureURI = DomUtils.getValue((Node)root, (String)"asic:SigReference/@URI");
                    if (!Utils.areStringsEqual((String)expectedSignatureURI, (String)signatureURI) || !this.checkManifestDigests(root)) continue;
                    DSSDocument dSSDocument = manifestDocument;
                    return dSSDocument;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to analyze manifest file '" + manifestDocument.getName() + "' : " + e.getMessage());
            }
        }
        return null;
    }

    private boolean checkManifestDigests(Element root) {
        NodeList dataObjectReferences = DomUtils.getNodeList((Node)root, (String)"asic:DataObjectReference");
        if (dataObjectReferences == null || dataObjectReferences.getLength() == 0) {
            LOG.warn("No DataObjectReference found in manifest file");
            return false;
        }
        for (int i = 0; i < dataObjectReferences.getLength(); ++i) {
            String computedDigestB64;
            Element dataObjectReference = (Element)dataObjectReferences.item(i);
            String filename = dataObjectReference.getAttribute("URI");
            DSSDocument signedFile = this.getSignedFileByName(filename);
            if (signedFile == null) {
                LOG.warn("Signed data with name '{}' not found", (Object)filename);
                return false;
            }
            DigestAlgorithm digestAlgo = this.getDigestAlgorithm(dataObjectReference);
            if (digestAlgo == null) {
                LOG.warn("Digest algo is not defined for signed data with name '{}'", (Object)filename);
                return false;
            }
            String expectedDigestB64 = this.getDigestValue(dataObjectReference);
            if (Utils.areStringsEqual((String)expectedDigestB64, (String)(computedDigestB64 = signedFile.getDigest(digestAlgo)))) continue;
            LOG.warn("Digest value doesn't match for signed data with name '{}'", (Object)filename);
            LOG.warn("Expected : '{}'", (Object)expectedDigestB64);
            LOG.warn("Computed : '{}'", (Object)computedDigestB64);
            return false;
        }
        return true;
    }

    private DSSDocument getSignedFileByName(String filename) {
        for (DSSDocument signedDocument : this.signedDocuments) {
            if (!Utils.areStringsEqual((String)filename, (String)signedDocument.getName())) continue;
            return signedDocument;
        }
        return null;
    }

    private DigestAlgorithm getDigestAlgorithm(Element element) {
        String xmlName = DomUtils.getElement((Node)element, (String)"ds:DigestMethod").getAttribute("Algorithm");
        return DigestAlgorithm.forXML((String)xmlName, null);
    }

    private String getDigestValue(Element element) {
        Element digestValueElement = DomUtils.getElement((Node)element, (String)"ds:DigestValue");
        if (digestValueElement != null) {
            return digestValueElement.getTextContent();
        }
        return "";
    }

    static {
        DomUtils.registerNamespace((String)"asic", (String)"http://uri.etsi.org/02918/v1.2.1#");
    }
}

