/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.validation;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.validation.ManifestFile;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ASiCEWithCAdESManifestParser {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCEWithCAdESManifestParser.class);
    private final DSSDocument manifestDocument;

    public ASiCEWithCAdESManifestParser(DSSDocument manifestDocument) {
        this.manifestDocument = manifestDocument;
    }

    public ManifestFile getDescription() {
        ManifestFile description = new ManifestFile();
        description.setFilename(this.manifestDocument.getName());
        try (InputStream is = this.manifestDocument.openStream();){
            Document manifestDom = DomUtils.buildDOM((InputStream)is);
            Element root = DomUtils.getElement((Node)manifestDom, (String)"asic:ASiCManifest");
            description.setSignatureFilename(DomUtils.getValue((Node)root, (String)"asic:SigReference/@URI"));
            description.setEntries(this.getDataObjectReferenceUris(root));
        }
        catch (Exception e) {
            LOG.warn("Unable to analyze manifest file '" + this.manifestDocument.getName() + "' : " + e.getMessage());
        }
        return description;
    }

    private List<String> getDataObjectReferenceUris(Element root) {
        ArrayList<String> entries = new ArrayList<String>();
        NodeList dataObjectReferences = DomUtils.getNodeList((Node)root, (String)"asic:DataObjectReference");
        if (dataObjectReferences == null || dataObjectReferences.getLength() == 0) {
            LOG.warn("No DataObjectReference found in manifest file");
        } else {
            for (int i = 0; i < dataObjectReferences.getLength(); ++i) {
                Element dataObjectReference = (Element)dataObjectReferences.item(i);
                entries.add(dataObjectReference.getAttribute("URI"));
            }
        }
        return entries;
    }
}

