/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.signature.asics;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.asic.ASiCParameters;
import eu.europa.esig.dss.asic.signature.GetDataToSignASiCWithCAdESHelper;
import eu.europa.esig.dss.asic.signature.asics.AbstractGetDataToSignASiCSWithCAdES;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collections;
import java.util.List;

public class DataToSignASiCSWithCAdESFromArchive
extends AbstractGetDataToSignASiCSWithCAdES
implements GetDataToSignASiCWithCAdESHelper {
    private final List<DSSDocument> embeddedSignatures;
    private final List<DSSDocument> embeddedSignedFiles;
    private final ASiCParameters asicParameters;

    public DataToSignASiCSWithCAdESFromArchive(List<DSSDocument> embeddedSignatures, List<DSSDocument> embeddedSignedFiles, ASiCParameters asicParameters) {
        this.embeddedSignatures = embeddedSignatures;
        this.embeddedSignedFiles = embeddedSignedFiles;
        this.asicParameters = asicParameters;
    }

    public String getSignatureFilename() {
        return this.getSignatureFileName(this.asicParameters);
    }

    @Override
    public DSSDocument getToBeSigned() {
        int nbEmbeddedSignatures = Utils.collectionSize(this.embeddedSignatures);
        if (nbEmbeddedSignatures != 1) {
            throw new DSSException("Unable to select the embedded signature (nb found:" + nbEmbeddedSignatures + ")");
        }
        return this.embeddedSignatures.get(0);
    }

    @Override
    public List<DSSDocument> getDetachedContents() {
        return this.getSignedDocuments();
    }

    public List<DSSDocument> getSignedDocuments() {
        int nbSignedFiles = Utils.collectionSize(this.embeddedSignedFiles);
        if (nbSignedFiles != 1) {
            throw new DSSException("Unable to select the document to be signed (nb found:" + nbSignedFiles + ")");
        }
        return this.embeddedSignedFiles;
    }

    public List<DSSDocument> getManifestFiles() {
        return Collections.emptyList();
    }

    public List<DSSDocument> getSignatures() {
        return this.embeddedSignatures;
    }
}

