/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.signature.asice;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.asic.ASiCWithCAdESSignatureParameters;
import eu.europa.esig.dss.asic.signature.GetDataToSignASiCWithCAdESHelper;
import eu.europa.esig.dss.asic.signature.asice.AbstractDataToSignASiCEWithCAdES;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DataToSignASiCEWithCAdESFromFiles
extends AbstractDataToSignASiCEWithCAdES
implements GetDataToSignASiCWithCAdESHelper {
    private final List<DSSDocument> filesToBeSigned;
    private final ASiCWithCAdESSignatureParameters parameters;
    private DSSDocument toBeSigned;

    public DataToSignASiCEWithCAdESFromFiles(List<DSSDocument> filesToBeSigned, ASiCWithCAdESSignatureParameters parameters) {
        this.filesToBeSigned = filesToBeSigned;
        this.parameters = parameters;
    }

    @Override
    public DSSDocument getToBeSigned() {
        if (this.toBeSigned == null) {
            this.toBeSigned = this.getASiCManifest(this.filesToBeSigned, Collections.emptyList(), Collections.emptyList(), this.parameters);
        }
        return this.toBeSigned;
    }

    @Override
    public List<DSSDocument> getDetachedContents() {
        return Collections.emptyList();
    }

    public String getSignatureFilename() {
        return this.getSignatureFileName(this.parameters.aSiC(), Collections.emptyList());
    }

    public List<DSSDocument> getSignedDocuments() {
        return this.filesToBeSigned;
    }

    public List<DSSDocument> getManifestFiles() {
        return Arrays.asList(this.getToBeSigned());
    }

    public List<DSSDocument> getSignatures() {
        return new ArrayList<DSSDocument>();
    }
}

