/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.signature;

import eu.europa.esig.dss.ASiCContainerType;
import eu.europa.esig.dss.AbstractSignatureParameters;
import eu.europa.esig.dss.DSSASN1Utils;
import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DSSUtils;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.InMemoryDocument;
import eu.europa.esig.dss.MimeType;
import eu.europa.esig.dss.SignatureLevel;
import eu.europa.esig.dss.SignaturePackaging;
import eu.europa.esig.dss.SignatureValue;
import eu.europa.esig.dss.SigningOperation;
import eu.europa.esig.dss.ToBeSigned;
import eu.europa.esig.dss.asic.ASiCParameters;
import eu.europa.esig.dss.asic.ASiCUtils;
import eu.europa.esig.dss.asic.ASiCWithCAdESContainerExtractor;
import eu.europa.esig.dss.asic.ASiCWithCAdESSignatureParameters;
import eu.europa.esig.dss.asic.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.asic.signature.ASiCWithCAdESDataToSignHelperBuilder;
import eu.europa.esig.dss.asic.signature.AbstractASiCSignatureService;
import eu.europa.esig.dss.asic.signature.GetDataToSignASiCWithCAdESHelper;
import eu.europa.esig.dss.asic.signature.asice.ASiCEWithCAdESArchiveManifestBuilder;
import eu.europa.esig.dss.asic.validation.ASiCEWithCAdESManifestValidator;
import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.signature.CAdESService;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class ASiCWithCAdESService
extends AbstractASiCSignatureService<ASiCWithCAdESSignatureParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCWithCAdESService.class);
    private static final String ZIP_ENTRY_ASICE_METAINF_CADES_TIMESTAMP = "META-INF/timestamp001.tst";

    public ASiCWithCAdESService(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
        LOG.debug("+ ASiCService with CAdES created");
    }

    public ToBeSigned getDataToSign(List<DSSDocument> toSignDocuments, ASiCWithCAdESSignatureParameters parameters) throws DSSException {
        ASiCParameters asicParameters = parameters.aSiC();
        this.assertCanBeSign(toSignDocuments, asicParameters);
        GetDataToSignASiCWithCAdESHelper dataToSignHelper = ASiCWithCAdESDataToSignHelperBuilder.getGetDataToSignHelper(toSignDocuments, parameters);
        CAdESSignatureParameters cadesParameters = this.getCAdESParameters(parameters);
        cadesParameters.setDetachedContents(dataToSignHelper.getDetachedContents());
        return this.getCAdESService().getDataToSign(dataToSignHelper.getToBeSigned(), cadesParameters);
    }

    public DSSDocument signDocument(List<DSSDocument> toSignDocuments, ASiCWithCAdESSignatureParameters parameters, SignatureValue signatureValue) throws DSSException {
        ASiCParameters asicParameters = parameters.aSiC();
        this.assertCanBeSign(toSignDocuments, asicParameters);
        this.assertSigningDateInCertificateValidityRange((AbstractSignatureParameters)parameters);
        GetDataToSignASiCWithCAdESHelper dataToSignHelper = ASiCWithCAdESDataToSignHelperBuilder.getGetDataToSignHelper(toSignDocuments, parameters);
        List signatures = dataToSignHelper.getSignatures();
        List manifests = dataToSignHelper.getManifestFiles();
        List archiveManifests = this.getEmbeddedArchiveManifests();
        List timestamps = this.getEmbeddedTimestamps();
        CAdESSignatureParameters cadesParameters = this.getCAdESParameters(parameters);
        cadesParameters.setDetachedContents(dataToSignHelper.getDetachedContents());
        boolean addASiCArchiveManifest = false;
        if (this.isAddASiCArchiveManifest(parameters)) {
            cadesParameters.setSignatureLevel(SignatureLevel.CAdES_BASELINE_LT);
            addASiCArchiveManifest = true;
        }
        DSSDocument signature = this.getCAdESService().signDocument(dataToSignHelper.getToBeSigned(), cadesParameters, signatureValue);
        String newSignatureFileName = dataToSignHelper.getSignatureFilename();
        signature.setName(dataToSignHelper.getSignatureFilename());
        if (ASiCUtils.isASiCS((ASiCParameters)asicParameters)) {
            Iterator iterator = signatures.iterator();
            while (iterator.hasNext()) {
                if (!Utils.areStringsEqual((String)newSignatureFileName, (String)((DSSDocument)iterator.next()).getName())) continue;
                iterator.remove();
            }
        }
        signatures.add(signature);
        if (addASiCArchiveManifest) {
            String timestampFilename = this.getArchiveTimestampFilename(timestamps);
            ASiCEWithCAdESArchiveManifestBuilder builder = new ASiCEWithCAdESArchiveManifestBuilder(signatures, dataToSignHelper.getSignedDocuments(), manifests, parameters.getArchiveTimestampParameters().getDigestAlgorithm(), timestampFilename);
            DSSDocument archiveManfest = DomUtils.createDssDocumentFromDomDocument((Document)builder.build(), (String)this.getArchivManifestFilename(archiveManifests));
            signatures.add(archiveManfest);
            DigestAlgorithm digestAlgorithm = parameters.getArchiveTimestampParameters().getDigestAlgorithm();
            TimeStampToken timeStampResponse = this.tspSource.getTimeStampResponse(digestAlgorithm, DSSUtils.digest((DigestAlgorithm)digestAlgorithm, (DSSDocument)archiveManfest));
            InMemoryDocument timestamp = new InMemoryDocument(DSSASN1Utils.getEncoded((TimeStampToken)timeStampResponse), timestampFilename, MimeType.TST);
            signatures.add(timestamp);
            cadesParameters.setSignatureLevel(SignatureLevel.CAdES_BASELINE_LTA);
        }
        DSSDocument asicSignature = this.buildASiCContainer(dataToSignHelper.getSignedDocuments(), signatures, manifests, asicParameters);
        asicSignature.setName(DSSUtils.getFinalFileName((DSSDocument)asicSignature, (SigningOperation)SigningOperation.SIGN, (SignatureLevel)parameters.getSignatureLevel(), (ASiCContainerType)parameters.aSiC().getContainerType()));
        parameters.reinitDeterministicId();
        return asicSignature;
    }

    public DSSDocument extendDocument(DSSDocument toExtendDocument, ASiCWithCAdESSignatureParameters parameters) throws DSSException {
        if (!ASiCUtils.isASiCContainer((DSSDocument)toExtendDocument) || !ASiCUtils.isArchiveContainsCorrectSignatureExtension((DSSDocument)toExtendDocument, (String)".p7s")) {
            throw new DSSException("Unsupported file type");
        }
        this.extractCurrentArchive(toExtendDocument);
        List signatureDocuments = this.getEmbeddedSignatures();
        List manifests = this.getEmbeddedManifests();
        List archiveManifests = this.getEmbeddedArchiveManifests();
        List timestamps = this.getEmbeddedTimestamps();
        List signedDocuments = this.getEmbeddedSignedDocuments();
        DSSDocument mimetype = this.getEmbeddedMimetype();
        ASiCContainerType containerType = ASiCUtils.getContainerType((DSSDocument)toExtendDocument, (DSSDocument)mimetype, null, (List)signedDocuments);
        if (containerType == null) {
            throw new DSSException("Unable to determine container type");
        }
        ArrayList<DSSDocument> extendedDocuments = new ArrayList<DSSDocument>();
        CAdESSignatureParameters cadesParameters = this.getCAdESParameters(parameters);
        boolean addASiCArchiveManifest = this.isAddASiCArchiveManifest(parameters);
        if (addASiCArchiveManifest) {
            cadesParameters.setSignatureLevel(SignatureLevel.CAdES_BASELINE_LT);
        }
        for (DSSDocument signature : signatureDocuments) {
            if (ASiCContainerType.ASiC_E == containerType) {
                ASiCEWithCAdESManifestValidator manifestValidator = new ASiCEWithCAdESManifestValidator(signature, manifests, signedDocuments);
                DSSDocument linkedManifest = manifestValidator.getLinkedManifest();
                if (linkedManifest != null) {
                    String originalName = signature.getName();
                    cadesParameters.setDetachedContents(Arrays.asList(linkedManifest));
                    DSSDocument extendDocument = this.getCAdESService().extendDocument(signature, cadesParameters);
                    extendDocument.setName(originalName);
                    extendedDocuments.add(extendDocument);
                    continue;
                }
                LOG.warn("Manifest not found for signature file '{}' -> NOT EXTENDED !!!", (Object)signature.getName());
                extendedDocuments.add(signature);
                continue;
            }
            String originalName = signature.getName();
            cadesParameters.setDetachedContents(signedDocuments);
            DSSDocument extendDocument = this.getCAdESService().extendDocument(signature, cadesParameters);
            extendDocument.setName(originalName);
            extendedDocuments.add(extendDocument);
        }
        if (addASiCArchiveManifest) {
            String timestampFilename = this.getArchiveTimestampFilename(timestamps);
            ASiCEWithCAdESArchiveManifestBuilder builder = new ASiCEWithCAdESArchiveManifestBuilder(extendedDocuments, signedDocuments, manifests, parameters.getArchiveTimestampParameters().getDigestAlgorithm(), timestampFilename);
            DSSDocument archiveManfest = DomUtils.createDssDocumentFromDomDocument((Document)builder.build(), (String)this.getArchivManifestFilename(archiveManifests));
            extendedDocuments.add(archiveManfest);
            DigestAlgorithm digestAlgorithm = parameters.getArchiveTimestampParameters().getDigestAlgorithm();
            TimeStampToken timeStampResponse = this.tspSource.getTimeStampResponse(digestAlgorithm, DSSUtils.digest((DigestAlgorithm)digestAlgorithm, (DSSDocument)archiveManfest));
            InMemoryDocument timestamp = new InMemoryDocument(DSSASN1Utils.getEncoded((TimeStampToken)timeStampResponse), timestampFilename, MimeType.TST);
            extendedDocuments.add((DSSDocument)timestamp);
            cadesParameters.setSignatureLevel(SignatureLevel.CAdES_BASELINE_LTA);
        }
        DSSDocument extensionResult = this.mergeArchiveAndExtendedSignatures(toExtendDocument, extendedDocuments);
        extensionResult.setName(DSSUtils.getFinalFileName((DSSDocument)toExtendDocument, (SigningOperation)SigningOperation.EXTEND, (SignatureLevel)parameters.getSignatureLevel(), (ASiCContainerType)parameters.aSiC().getContainerType()));
        return extensionResult;
    }

    private String getArchivManifestFilename(List<DSSDocument> archiveManifests) {
        String suffix = Utils.isCollectionEmpty(archiveManifests) ? "" : String.valueOf(archiveManifests.size());
        return "META-INF/ASiCArchiveManifest" + suffix + ".xml";
    }

    private String getArchiveTimestampFilename(List<DSSDocument> timestamps) {
        int num = Utils.collectionSize(timestamps) + 1;
        return ZIP_ENTRY_ASICE_METAINF_CADES_TIMESTAMP.replace("001", ASiCUtils.getPadNumber((int)num));
    }

    boolean isSignatureFilename(String name) {
        return ASiCUtils.isCAdES((String)name);
    }

    AbstractASiCContainerExtractor getArchiveExtractor(DSSDocument archive) {
        return new ASiCWithCAdESContainerExtractor(archive);
    }

    private CAdESService getCAdESService() {
        CAdESService cadesService = new CAdESService(this.certificateVerifier);
        cadesService.setTspSource(this.tspSource);
        return cadesService;
    }

    private CAdESSignatureParameters getCAdESParameters(ASiCWithCAdESSignatureParameters parameters) {
        ASiCWithCAdESSignatureParameters cadesParameters = parameters;
        cadesParameters.setSignaturePackaging(SignaturePackaging.DETACHED);
        cadesParameters.setDetachedContents(null);
        return cadesParameters;
    }

    private boolean isAddASiCArchiveManifest(ASiCWithCAdESSignatureParameters parameters) {
        return SignatureLevel.CAdES_BASELINE_LTA == parameters.getSignatureLevel() && ASiCContainerType.ASiC_E == parameters.aSiC().getContainerType();
    }

    String getExpectedSignatureExtension() {
        return ".p7s";
    }
}

