/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature;

import eu.europa.esig.dss.asic.cades.validation.ASiCWithCAdESManifestParser;
import eu.europa.esig.dss.asic.cades.validation.ASiCWithCAdESUtils;
import eu.europa.esig.dss.asic.common.ASiCContent;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.signature.CAdESService;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.x509.tsp.TSPSource;
import eu.europa.esig.dss.validation.CertificateVerifier;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class ASiCWithCAdESSignatureExtension
implements Serializable {
    private static final long serialVersionUID = 4054926235641779454L;
    protected final CertificateVerifier certificateVerifier;
    protected final TSPSource tspSource;
    private CAdESService cadesService;

    public ASiCWithCAdESSignatureExtension(CertificateVerifier certificateVerifier, TSPSource tspSource) {
        this.certificateVerifier = certificateVerifier;
        this.tspSource = tspSource;
    }

    public ASiCContent extend(ASiCContent asicContent, CAdESSignatureParameters parameters) {
        List signatureDocuments = asicContent.getSignatureDocuments();
        ASiCContainerType containerType = asicContent.getContainerType();
        if (containerType == null) {
            throw new IllegalInputException("The container type of the provided document is not supported or cannot be extracted!");
        }
        for (DSSDocument signature : signatureDocuments) {
            boolean coveredByManifest = this.isCoveredByManifest(asicContent, signature);
            if (!this.extensionRequired(parameters, coveredByManifest)) continue;
            this.assertExtendSignaturePossible(parameters, coveredByManifest);
            DSSDocument extendedSignature = this.extendSignatureDocument(signature, asicContent, parameters);
            ASiCUtils.addOrReplaceDocument((List)signatureDocuments, (DSSDocument)extendedSignature);
        }
        return asicContent;
    }

    private DSSDocument extendSignatureDocument(DSSDocument signature, ASiCContent asicContent, CAdESSignatureParameters cadesParameters) {
        List<DSSDocument> detachedContents = this.getDetachedContents(signature, asicContent);
        cadesParameters.getContext().setDetachedContents(detachedContents);
        String originalName = signature.getName();
        DSSDocument extendDocument = this.getCAdESService().extendDocument(signature, cadesParameters);
        extendDocument.setName(originalName);
        return extendDocument;
    }

    private List<DSSDocument> getDetachedContents(DSSDocument signatureDocument, ASiCContent asicContent) {
        if (ASiCContainerType.ASiC_E == asicContent.getContainerType()) {
            List manifests = asicContent.getManifestDocuments();
            DSSDocument linkedManifest = ASiCWithCAdESManifestParser.getLinkedManifest(manifests, signatureDocument.getName());
            return Collections.singletonList(linkedManifest);
        }
        return asicContent.getSignedDocuments();
    }

    protected DigestAlgorithm getReferenceDigestAlgorithmOrDefault(CAdESSignatureParameters params) {
        return params.getReferenceDigestAlgorithm() != null ? params.getReferenceDigestAlgorithm() : params.getDigestAlgorithm();
    }

    private CAdESService getCAdESService() {
        if (this.cadesService == null) {
            this.cadesService = new CAdESService(this.certificateVerifier);
            this.cadesService.setTspSource(this.tspSource);
        }
        return this.cadesService;
    }

    protected boolean extensionRequired(CAdESSignatureParameters parameters, boolean coveredByManifest) {
        SignatureLevel signatureLevel = parameters.getSignatureLevel();
        return SignatureLevel.CAdES_BASELINE_T.equals((Object)signatureLevel) || SignatureLevel.CAdES_BASELINE_LT.equals((Object)signatureLevel) || !coveredByManifest;
    }

    protected void assertExtendSignaturePossible(CAdESSignatureParameters parameters, boolean coveredByManifest) {
        SignatureLevel signatureLevel = parameters.getSignatureLevel();
        if ((SignatureLevel.CAdES_BASELINE_T.equals((Object)signatureLevel) || SignatureLevel.CAdES_BASELINE_LT.equals((Object)signatureLevel)) && coveredByManifest) {
            throw new IllegalInputException(String.format("Cannot extend signature to '%s'. The signature is already covered by an archive manifest.", signatureLevel));
        }
    }

    protected boolean isCoveredByManifest(ASiCContent asicContent, DSSDocument signature) {
        return ASiCWithCAdESUtils.isCoveredByManifest(asicContent.getAllManifestDocuments(), signature.getName());
    }
}

