/*
 * Decompiled with CFR 0.152.
 */
package org.digidoc4j.ddoc.c14n;

import org.digidoc4j.ddoc.c14n.FragmentBase;
import org.digidoc4j.ddoc.c14n.TextPositionInfo;
import org.digidoc4j.ddoc.c14n.TinyXMLParser_Document;

public final class TinyXMLParser_Fragment
extends FragmentBase {
    public TinyXMLParser_Document OwnerDocument;
    private TinyXMLParser_Fragment _next;

    private boolean GetMarkupChar(int o) {
        return "<?![=]/->".indexOf(this.GetChar(o)) > -1;
    }

    private boolean GetSpaceChar(int o) {
        return "\t\n\r ".indexOf(this.GetChar(o)) > -1;
    }

    private boolean GetQuoteChar(int o) {
        return "\"'".indexOf(this.GetChar(o)) > -1;
    }

    private boolean GetLiteralChar(int o) {
        if (this.GetMarkupChar(o)) {
            return false;
        }
        if (this.GetSpaceChar(o)) {
            return false;
        }
        return !this.GetQuoteChar(o);
    }

    public boolean get_IsMarkup() {
        return this.GetMarkupChar(0);
    }

    public boolean get_IsSpace() {
        return this.GetSpaceChar(0);
    }

    public boolean get_IsQuote() {
        return this.GetQuoteChar(0);
    }

    public boolean get_IsLiteral() {
        return this.GetLiteralChar(0);
    }

    private void SpawnAtOffset(int p) {
        this.Offset = p;
        this.Length = -1;
        if (this.GetMarkupChar(0)) {
            this.Length = 0;
            while (this.InBounds(this.get_LastOffset()) && this.GetMarkupChar(this.Length)) {
                ++this.Length;
            }
            return;
        }
        if (this.GetSpaceChar(0)) {
            this.Length = 0;
            while (this.InBounds(this.get_LastOffset()) && this.GetSpaceChar(this.Length)) {
                ++this.Length;
            }
            return;
        }
        if (this.GetQuoteChar(0)) {
            this.Length = 0;
            while (this.InBounds(this.get_LastOffset()) && this.GetQuoteChar(this.Length)) {
                ++this.Length;
            }
            return;
        }
        if (this.GetLiteralChar(0)) {
            this.Length = 0;
            while (this.InBounds(this.get_LastOffset()) && this.GetLiteralChar(this.Length)) {
                ++this.Length;
            }
        }
    }

    public TinyXMLParser_Fragment Clone() {
        return TinyXMLParser_Fragment.Of(this.Data, this.Offset);
    }

    private TinyXMLParser_Fragment get_InternalNext() {
        if (this._next == null) {
            this._next = TinyXMLParser_Fragment.Of(this.Data, this.get_LastOffset());
            if (this._next != null) {
                this._next.OwnerDocument = this.OwnerDocument;
            }
        }
        return this._next;
    }

    public TinyXMLParser_Fragment get_Next() {
        if (this.get_InternalNext() != null) {
            this.get_InternalNext().SplitMarkup();
        }
        return this.get_InternalNext();
    }

    public TinyXMLParser_Fragment get_NextNonSpace() {
        TinyXMLParser_Fragment f = this.get_Next();
        boolean seek = true;
        while (seek) {
            if (f == null) {
                seek = false;
            } else if (!f.get_IsSpace()) {
                seek = false;
            }
            if (!seek) continue;
            f = f.get_Next();
        }
        return f;
    }

    public void SplitMarkup() {
        if (this.get_IsMarkup()) {
            String[] stringArray1 = new String[]{"<!--", "-->", "<?", "?>", "<![", "]]>", "[", "]", "<!", "/>", "</", ">", "<", "="};
            if (!this.SplitBy(stringArray1)) {
                this.SplitBy(1);
            }
            return;
        }
        if (this.get_IsQuote()) {
            String[] stringArray1 = new String[]{"'", "\""};
            this.SplitBy(stringArray1);
        }
    }

    public void JoinNonMarkup() {
        boolean seek = true;
        while (seek) {
            if (this.get_InternalNext() == null) {
                seek = false;
            } else if (this.get_InternalNext().get_IsMarkup()) {
                String[] stringArray2 = new String[]{"<![", "<!--", "<?", "<", "</", "<!"};
                if (this.get_Next().get_Item(stringArray2)) {
                    seek = false;
                }
            }
            if (!seek) continue;
            this.Join(this.get_InternalNext());
        }
    }

    public void Join(TinyXMLParser_Fragment e) {
        this._next = null;
        this.Length += e.Length;
    }

    private void SplitBy(int len) {
        if (len < this.Length) {
            TinyXMLParser_Fragment n1;
            TinyXMLParser_Fragment n2 = this.get_InternalNext();
            this._next = n1 = this.Clone();
            this._next._next = n2;
            FragmentBase.SplitBy(this, n1, len);
        }
    }

    @Override
    protected boolean SplitBy(String e) {
        if (this.StartsWith(e)) {
            if (e.length() < this.Length) {
                TinyXMLParser_Fragment n1;
                TinyXMLParser_Fragment n2 = this.get_InternalNext();
                this._next = n1 = this.Clone();
                this._next._next = n2;
                FragmentBase.SplitBy(this, n1, e.length());
            }
            return true;
        }
        return false;
    }

    public TextPositionInfo get_TextPosition() {
        return new TextPositionInfo(this.Data, this.Offset);
    }

    public static TinyXMLParser_Fragment Of(byte[] data, int offset) {
        TinyXMLParser_Fragment n = new TinyXMLParser_Fragment();
        n.Data = data;
        if (n.InBounds(offset)) {
            n.SpawnAtOffset(offset);
        } else {
            n = null;
        }
        return n;
    }
}

