/*
 * Decompiled with CFR 0.152.
 */
package org.digidoc4j.ddoc;

import java.io.Serializable;
import java.util.ArrayList;
import org.digidoc4j.ddoc.DigiDocException;

public class NoticeRef
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String m_organization;
    private ArrayList m_noticeNumbers;

    public NoticeRef(String org) {
        this.m_organization = org;
        this.m_noticeNumbers = null;
    }

    public String getOrganization() {
        return this.m_organization;
    }

    public void setOrganization(String str) throws DigiDocException {
        DigiDocException ex = this.validateOrganization(str);
        if (ex != null) {
            throw ex;
        }
        this.m_organization = str;
    }

    private DigiDocException validateOrganization(String str) {
        DigiDocException ex = null;
        if (str == null) {
            ex = new DigiDocException(167, "Organization is a required attribute", null);
        }
        return ex;
    }

    public int countNoticeNumbers() {
        return this.m_noticeNumbers == null ? 0 : this.m_noticeNumbers.size();
    }

    public void addNoticeNumber(int n) {
        if (this.m_noticeNumbers == null) {
            this.m_noticeNumbers = new ArrayList();
        }
        this.m_noticeNumbers.add(new Integer(n));
    }

    public int getNoticeNumber(int idx) {
        if (this.m_noticeNumbers != null && idx < this.m_noticeNumbers.size()) {
            return (Integer)this.m_noticeNumbers.get(idx);
        }
        return 0;
    }

    public ArrayList validate() {
        ArrayList<DigiDocException> errs = new ArrayList<DigiDocException>();
        DigiDocException ex = this.validateOrganization(this.m_organization);
        if (ex != null) {
            errs.add(ex);
        }
        return errs;
    }
}

