/*
 * Decompiled with CFR 0.152.
 */
package org.digidoc4j.ddoc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import org.digidoc4j.ddoc.DigiDocException;
import org.digidoc4j.ddoc.ManifestFileEntry;
import org.digidoc4j.ddoc.utils.ConvertUtils;

public class Manifest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String MANIFEST_URN = "urn:oasis:names:tc:opendocument:xmlns:manifest:1.0";
    public static final String MANIFEST_BDOC_MIME_1_0 = "application/vnd.bdoc-1.0";
    public static final String MANIFEST_BDOC_MIME_1_1 = "application/vnd.bdoc-1.1";
    public static final String MANIFEST_BDOC_MIME_2_0 = "application/vnd.etsi.asic-e+zip";
    private ArrayList m_fileEntries = null;

    public int getNumFileEntries() {
        return this.m_fileEntries != null ? this.m_fileEntries.size() : 0;
    }

    public ManifestFileEntry getFileEntry(int nIdx) {
        if (nIdx >= 0 && this.m_fileEntries != null && nIdx < this.m_fileEntries.size()) {
            return (ManifestFileEntry)this.m_fileEntries.get(nIdx);
        }
        return null;
    }

    public void addFileEntry(ManifestFileEntry fe) {
        if (this.m_fileEntries == null) {
            this.m_fileEntries = new ArrayList();
        }
        this.m_fileEntries.add(fe);
    }

    public void removeFileEntry(int nIdx) {
        if (nIdx >= 0 && this.m_fileEntries != null && nIdx < this.m_fileEntries.size()) {
            this.m_fileEntries.remove(nIdx);
        }
    }

    public void removeFileEntryWithPath(String fullPath) {
        for (int i = 0; this.m_fileEntries != null && i < this.m_fileEntries.size(); ++i) {
            ManifestFileEntry fe = (ManifestFileEntry)this.m_fileEntries.get(i);
            if (!fe.getFullPath().equals(fullPath)) continue;
            this.m_fileEntries.remove(i);
        }
    }

    public ManifestFileEntry findFileEntryByPath(String fullPath) {
        for (int i = 0; this.m_fileEntries != null && i < this.m_fileEntries.size(); ++i) {
            ManifestFileEntry fe = (ManifestFileEntry)this.m_fileEntries.get(i);
            if (!fe.getFullPath().equals(fullPath)) continue;
            return fe;
        }
        return null;
    }

    public byte[] toXML() throws DigiDocException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            bos.write(ConvertUtils.str2data("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n"));
            bos.write(ConvertUtils.str2data("<manifest:manifest xmlns:manifest=\""));
            bos.write(ConvertUtils.str2data(MANIFEST_URN));
            bos.write(ConvertUtils.str2data("\">\n"));
            for (int i = 0; this.m_fileEntries != null && i < this.m_fileEntries.size(); ++i) {
                ManifestFileEntry fe = (ManifestFileEntry)this.m_fileEntries.get(i);
                bos.write(fe.toXML());
            }
            bos.write(ConvertUtils.str2data("</manifest:manifest>\n"));
        }
        catch (IOException ex) {
            DigiDocException.handleException(ex, 89);
        }
        return bos.toByteArray();
    }

    public String toString() {
        String str = null;
        try {
            str = new String(this.toXML());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }
}

