/*
 * Decompiled with CFR 0.152.
 */
package org.diet4j.runjunit;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.diet4j.core.ModuleClassLoader;
import org.diet4j.core.NoClassDefFoundWithClassLoaderError;

public class ToplevelClassLoader
extends ModuleClassLoader {
    protected File[] theDirs;
    private static final Logger log = Logger.getLogger(ToplevelClassLoader.class.getName());

    public ToplevelClassLoader(File[] dirs, ClassLoader parent, ModuleClassLoader[] dependencyClassLoaders, String[] doNotLoadClassPrefixes) {
        super(null, parent, dependencyClassLoaders, doNotLoadClassPrefixes);
        this.theDirs = dirs;
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        boolean closeReporting = false;
        Class c = this.findLoadedClass(name);
        if (c == null) {
            closeReporting = true;
            log.log(Level.FINER, "loadClassAttemptStart: {0} ({1})", new Object[]{((Object)((Object)this)).getClass().getName(), name});
            if (this.cannotFindTable.get(name) == null) {
                ClassLoader consultDefaultClassLoader = null;
                for (String prefix : this.theDoNotLoadClassPrefixes) {
                    if (!name.startsWith(prefix)) continue;
                    consultDefaultClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
                    break;
                }
                if (consultDefaultClassLoader != null) {
                    try {
                        c = consultDefaultClassLoader.loadClass(name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (c == null) {
                    String path = name.replace('.', '/').concat(".class");
                    for (File dir : this.theDirs) {
                        File file = new File(dir, path);
                        if (!file.canRead()) continue;
                        try {
                            byte[] classBytes = ToplevelClassLoader.slurpFile(file);
                            if (classBytes == null || classBytes.length <= 0) continue;
                            c = this.defineClass(name, classBytes, 0, classBytes.length);
                        }
                        catch (IOException ex) {
                            log.log(Level.WARNING, "Failed to read from " + file.getPath(), ex);
                        }
                        catch (NoClassDefFoundWithClassLoaderError ex) {
                            throw ex;
                        }
                        catch (NoClassDefFoundError ex) {
                            throw new NoClassDefFoundWithClassLoaderError(ex.getMessage(), (ModuleClassLoader)this);
                        }
                        catch (ClassFormatError ex) {
                            log.log(Level.SEVERE, "loadClassAttemptStart: " + (Object)((Object)this) + " (" + name + ")", ex);
                        }
                    }
                }
                if (c == null) {
                    for (int i = 0; i < this.theDependencyClassLoaders.length; ++i) {
                        if (this.theDependencyClassLoaders[i] == null) continue;
                        try {
                            c = this.theDependencyClassLoaders[i].loadClass(name, false);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                        if (c != null) break;
                    }
                }
            }
        }
        if (c == null) {
            this.cannotFindTable.put(name, CANNOT_FIND_OBJECT);
            if (closeReporting) {
                log.log(Level.FINE, "loadClass failed: Module {0} (class: {1})", new Object[]{((Object)((Object)this)).getClass().getName(), name});
            }
            throw new ClassNotFoundException(name + " (" + ((Object)((Object)this)).getClass().getName() + ")");
        }
        if (resolve) {
            this.resolveClass(c);
        }
        if (closeReporting) {
            log.log(Level.FINER, "loadClass succeeded: {0} ({1})", new Object[]{((Object)((Object)this)).getClass().getName(), name});
        }
        return c;
    }

    public URL findResource(String name) {
        for (File dir : this.theDirs) {
            File file = new File(dir, name);
            if (!file.canRead()) continue;
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException ex) {
                log.log(Level.SEVERE, "findResource: " + (Object)((Object)this) + " (" + name + ")", ex);
            }
        }
        return null;
    }

    protected static byte[] slurpFile(File file) throws IOException {
        FileInputStream inStream = new FileInputStream(file);
        byte[] buf = new byte[512];
        int offset = 0;
        while (true) {
            int stillToReadIntoBuf;
            int count;
            if ((count = inStream.read(buf, offset, stillToReadIntoBuf = buf.length - offset)) == -1) {
                int length = offset;
                if (count > 0) {
                    length += count;
                }
                if (buf.length == length) {
                    return buf;
                }
                byte[] ret = new byte[length];
                System.arraycopy(buf, 0, ret, 0, length);
                return ret;
            }
            if (offset + count == buf.length) {
                byte[] newBuf = new byte[buf.length * 2];
                System.arraycopy(buf, 0, newBuf, 0, buf.length);
                buf = newBuf;
            }
            offset += count;
        }
    }
}

