/*
 * Decompiled with CFR 0.152.
 */
package org.diet4j.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarFile;
import org.diet4j.core.AbstractScanningModuleRegistry;
import org.diet4j.core.MiniModuleMetaMap;
import org.diet4j.core.Module;

public class ScanningClasspathModuleRegistry
extends AbstractScanningModuleRegistry {
    public static synchronized ScanningClasspathModuleRegistry instantiate() throws IllegalStateException, IOException {
        if (theSingleton != null) {
            throw new IllegalStateException("Have a singleton already: " + theSingleton);
        }
        HashMap<String, MiniModuleMetaMap> metas = ScanningClasspathModuleRegistry.findModuleMetas(ScanningClasspathModuleRegistry.class.getClassLoader());
        theSingleton = new ScanningClasspathModuleRegistry(metas);
        return (ScanningClasspathModuleRegistry)theSingleton;
    }

    private ScanningClasspathModuleRegistry(HashMap<String, MiniModuleMetaMap> metas) {
        super(metas, new String[0]);
    }

    @Override
    public ClassLoader createClassLoader(Module module, ClassLoader parentClassLoader) {
        return parentClassLoader;
    }

    protected static HashMap<String, MiniModuleMetaMap> findModuleMetas(ClassLoader cl) throws IOException {
        Enumeration<URL> metaInfoUrls = cl.getResources("META-INF/");
        ArrayList<JarFile> jars = new ArrayList<JarFile>();
        ArrayList<File> dirs = new ArrayList<File>();
        while (metaInfoUrls.hasMoreElements()) {
            URL metaInfoUrl = metaInfoUrls.nextElement();
            switch (metaInfoUrl.getProtocol()) {
                case "jar": {
                    int excl;
                    String jarFile = metaInfoUrl.getFile();
                    int colon = jarFile.indexOf(":");
                    if (colon > 0) {
                        jarFile = jarFile.substring(colon + 1);
                    }
                    if ((excl = jarFile.indexOf("!")) > 0) {
                        jarFile = jarFile.substring(0, excl);
                    }
                    JarFile jar = new JarFile(jarFile);
                    jars.add(jar);
                    break;
                }
                case "file": {
                    File dir = new File(metaInfoUrl.getFile());
                    if (!dir.isDirectory()) break;
                    dirs.add(dir);
                }
            }
        }
        HashMap<String, MiniModuleMetaMap> metas = new HashMap<String, MiniModuleMetaMap>();
        ScanningClasspathModuleRegistry.addParsedModuleMetasFromJars(jars, metas);
        ScanningClasspathModuleRegistry.addParsedModuleMetasFromDirectories(dirs, metas);
        return metas;
    }
}

